function [n, status] = nma_verify_valid_positive_integer(str, h, msg)
%verifies input string represents positive integer

[n, status] = str2num(str);

if not(status)
   uiwait(errordlg(sprintf('non - numeric value for %s',msg),...
      'Bad Input', 'modal'));
   uicontrol(h);
   return
end

if abs(n) < 2 * eps
   uiwait(errordlg(sprintf('%s must be positive',msg),...
      'Bad Input', 'modal'));
   uicontrol(h);
   status = 0;
   return
end

if n < 0
   uiwait(errordlg(sprintf('%s must be positive',msg),...
      'Bad Input', 'modal'));
   uicontrol(h);
   status = 0;
   return
end

if round(n) ~= n
   uiwait(errordlg(sprintf('%s must be integer',msg),...
      'Bad Input', 'modal'));
   uicontrol(h);
   status = 0;
   return
end

status = 1;

end
