function I=nma_trapezoidal(func,from,to,nStrips)
%integrate a function using trapezoidal rule using specific number of strips.

%function r=nma_trapezoidal(f,from,to,nStrips)
%
% integrates a function using trapezoidal rule using
% specific number of strips.
%
% INPUT:
%   f : a string that repesents the function itself
%       for example 'x*sin(x)'. The independent variable
%       used in the string must be 'x' and no other letter.
%
%  from: lower limit
%  to  : upper limit
%  nStrips: number of strips to use
%
% OUTPUT
%   I : The integral.
%
%
% Example:
% nma_trapezoidal('cos(x)',-1,0,10)
% ans =
%     0.8408
%
% nma_trapezoidal('cos(x)',-1,0,100)
% ans =
%     0.8415
%
% quad('cos(x)',-1,0)
% ans =
%     0.8415
%
% copyright: Nasser M. Abbasi
% May 3, 2003

I=0;

if(from > to)
    error('lower limit can not be smaller than upper limit');
end

if(nStrips<=0)
    error('number of strips must be > 0');
end

if( abs(from-to)<eps )
    I = 0;
else
    
    nPoints = nStrips+1;
    h = abs((from-to))/(nStrips);
    X = from:h:to;
    
    for i=1:nPoints
        x=X(i);
        f = eval(func);
        if(i==1 || i==nPoints )
            I=I+f ;
        else
            I=I+2*f;
        end
    end
    
    I=I*h/2;
end
