function alpha=nma_findAlphaForMinDeltaV(r1,r2,beta,mu)
% Finds initial inclincatin correction for orbit relative to a larger circular orbit

%function alpha=nma_findAlphaForMinDeltaV(r1,r2,beta,mu)
%
% Finds the minumum alpha (initial inclincatin correction)
% for an orbit relative to a larger circular orbit.
% see design note for more detailes.
%
%INPUT:
%  r1: The radius of the smaller circular orbit
%  r2: the radius of the larger circular orbit
%  beta: the angle, in degrees, in which the two
%        circular orbits are non co-planers to
%        each others.
% mu: gavitional constant
%
% OUTPUT:
%  alpha: The angle in degrees to use for initial
%         correction such that minumum delta V is
%         obtained to move from the smaller circular
%         orbit to the larger circular orbit
%
% Author: Nasser Abbasi
%         May 19,2003


a= (r1+r2)/2;
rp=r1;
ra=r2;

Va=sqrt( mu*(2/ra - 1/a ));
Vp=sqrt( mu*(2/rp - 1/a ));

Vc1=sqrt( mu/r1 );
Vc2=sqrt( mu/r2 );

beta=beta*pi/180;

root(1)=0.1*beta;
keepLooking=true;
i=0;

while(keepLooking)
    i=i+1;
    root(i+1)=root(i)-   ( F(Vc1,Vc2,Vp,Va,root(i),beta)/dF(Vc1,Vc2,Vp,Va,root(i),beta) );
    root(i+1)
    if( abs ( (root(i+1) - root(i)) / root(i+1) ) * 100  < 0.001 )
        keepLooking=false;
    else
        
        if( ( root(i+1) * root(i) )<0.0)
            error('jumped out of root');
        end
    end
    if(i>100)
        error('Failed to converge');
    end
end

alpha=root(end);
alpha=alpha*180/pi;

%%%%%%%%%%%%%%%
%
%
%%%%%%%%%%%%%%%%
function v=F(Vc1,Vc2,Vp,Va,alpha,beta)

v=Vc1*Vp*sin(alpha)*sqrt(Vc2^2+Va^2-2*Vc2*Va*cos(beta-alpha)) ...
    - Vc2*Va*sin(beta-alpha)*sqrt(Vc1^2+Vp^2-2*Vc1*Vp*cos(alpha));

%%%%%%%%%%%%%%%
%
%
%%%%%%%%%%%%%%%%
function v=dF(Vc1,Vc2,Vp,Va,alpha,beta)


v=Vc1*Vp*cos(alpha)*sqrt(Vc2^2+Va^2-2*Vc2*Va*cos(beta-alpha)) ...
    +Vc1*Vp*sin(alpha)* ...
    ( -Vc2*Va*sin(beta-alpha)/sqrt(Vc2^2+Va^2-2*Vc2*Va*cos(beta-alpha))) ...
    - (Vc2*Va*cos(beta-alpha)*sqrt(Vc1^2+Vp^2-2*Vc1*Vp*cos(alpha)) ...
    + Vc2*Va*sin(beta-alpha)*...
    ( Vc1*Vp*sin(alpha) /  sqrt(Vc1^2+Vp^2-2*Vc1*Vp*cos(alpha))));


