function nma_spline_test
%driver for cubic splines using the improved method.

%Driver for the second project MAE 185. UCI, May 2003.
%find the cubic splines using the improved method.
%
% Author: Naseer Abbasi
%

fprintf('Please enter the X and Y coordinates of each point separately.\n');
fprintf('Enter as many points as you wish. There is no hardcoded limit.\n');
fprintf('When done, simply hit RETURN without typing anything on the line. \n');

inputNotGood=true;

nPoints=0;
while(inputNotGood)
    nPoints=nPoints+1;   
    
    x=input(sprintf('x[%d] ?  >',nPoints));
    if(isempty(x))
        if(nPoints-1 <3)
            fprintf('Must enter at least 3 points. Please try all over from the start\n');
            nPoints=0;
            X=[];
            Y=[];            
        else
            inputNotGood=false;
            nPoints=nPoints-1;
        end
    else
        if(~isnumeric(x))
            fprintf('Must enter a numeric value. Please start all over.\n');
            nPoints=0;
            X=[];
            Y=[];                        
        else                        
            y=input(sprintf('y[%d] ?  >',nPoints));      
            if(isempty(y))
                fprintf('Error. Must enter a y coordinate for the x-coordinate above. Please start all over.\n');
                nPoints=0;         
                X=[];
                Y=[];            
            else
                if(~isnumeric(y))
                    fprintf('y coordicate must be a numeric value. Please start all over.\n');
                    nPoints=0;
                    X=[];
                    Y=[];                        
                else                
                    X(nPoints)=x;
                    Y(nPoints)=y;
                    fprintf('\n');
                end
            end
        end
    end
end

% for testing:
%X=[0 1 1.5 2.25];
%Y=[2 4.4366 6.7134 13.913];
%nPoints=4;

[a,b,c,d,sp]=nma_spline_test(X,Y);

fprintf('The cubic splines are:\n');
for(i=1:nPoints-1)
    fprintf('%s\n',sp{i});   
    fprintf('Range is from x=%f to x=%f \n\n',X(i),X(i+1));
end

figure;

digits(4);
for(i=1:nPoints-1)
    plot(X(i),Y(i),'o');
    S=latex(simplify(sym(sp{i})));
    j=0;
    skipLetter=false;
    for(k=1:length(S))        
        if(skipLetter)
            skipLetter=false;
        else
            if(S(k)=='\\')
                skipLetter=true;      
            else
                j=j+1;
                Snew(j)=S(k);
            end
        end
    end
    
    % find where to display the formula
    deltaY=abs((Y(i+1)-Y(i))/2);
    if(Y(i+1)>Y(i))
        ytext=Y(i) + deltaY;
    else
        ytext=Y(i) - deltaY;
    end
    xtext=X(i)+  (X(i+1)-X(i))/2 ;
    xtext=xtext+0.05*(xtext);
    
    text(xtext,ytext,Snew,'FontSize',8);
    hold on;
    ezplot(sp{i},X(i),X(i+1));
end
plot(X(end),Y(end),'o');

Y_extent=abs(Y(end))+abs(Y(1));
X_extent=abs(Y(end))+abs(Y(1));

ylim([min(Y)-0.15*Y_extent   max(Y)+0.15*Y_extent]);
xlim([min(X)-0.25*X_extent  max(X)+0.25*X_extent]);

title('Cubic splines by the improved spline method. Project 2 MAE 185');
xlabel('x');
ylabel('y');

%grid;
