function R=nma_romberg(firstColumn)
%generate the Romberg integration table

%
% Function to generate the Romberg integration table given the
% first column (which should be the result of the trapozidal
% integration, for number of strips n=1,2,4,8,16,....
%
% INPUT
%   firstColumn: a Vector whose elements represent the integral
%   for different number of strips. The first element if trapozidal
%   integral for n=1, second element in the vector is for
%   trapozidal integral for n=2, the third element is for n=4,
%   and so forth. Notice that n goes as 2^i where i is the
%   position number in the vector. Use nma_trapezoidal to generate
%   the integral for specific n values and use the output to feed
%   it to this function.
%
% OUTPUT:
%   a Matrix R the reppresents the romberg table. The first column of the
%   matrix is the same as the input argument. The remaining columns are
%   the result of the extrapolation used.
%
%   see nma_testRomberg.m for an example of how to use these functions
%
% Copyright: Nasser Abbasi
%

% change history
% name   date       change
% nma   5/2/03      started. To solve HW#4, MAE 185. UCI
% nma   10/18/2010  cleaned up.

len=length(firstColumn);

R=zeros(len);
R(:,1)=firstColumn';
nEntries=len;
k=1;
while(nEntries ~= 0)
    k=k+1;
    F= 4^(k-1);
    for j=1:nEntries-1
        R(j,k)=  ( F*R(j+1,k-1) - R(j,k-1) )/ (F-1);
    end
    nEntries=nEntries-1;
end
