classdef nma_rect_pulse_on_periodic_1D < handle
%class implements the rectangular pulse used in implementation of HW3, Math 228B.

%
% This class implements the rectangular pulse, which is used
% in implementation of HW3, Math 228B.
%
%Nasser M. Abbasi
%UC Davis, Math 228B


   
   properties(GetAccess = 'private', SetAccess = 'private')
      width;
      height;
      grid_h;
      X;
      domain_length=0;
   end
   
   methods
      %CONSTRUCTOR
      %-------------------------------------------------------
      function obj = nma_rect_pulse_on_periodic_1D(width,height,domain_length,grid_h)
         obj.width         = width;
         obj.height        = height;
         obj.grid_h        = grid_h;
         obj.X             = 0:grid_h:domain_length;
         obj.domain_length = domain_length;
      end
      
      %-----------------------------------------------------
      % THis function returns the pulse based on starting location
      % and its properies used during construction on the object
      function u = get(obj,startAt)
         L = obj.domain_length;
         startAt = mod(startAt,L);
         
         if startAt+obj.width <= L
            u=obj.height* ( heaviside(obj.X-startAt)- ...
               heaviside(obj.X-(startAt+obj.width)) );
         else
            u=obj.height*(  ( heaviside(obj.X-startAt)- ...
               heaviside(obj.X-L)) + ...
               ( heaviside(obj.X) - ...
               heaviside(obj.X-(obj.width-(L-startAt)))));
         end
      end
      
   end
end
