function is_symmetric = nma_ISSYM( A )
% checks that matrix is symmetrix

%----------------------------------------------
%file name: nma_ISSYM.m
%
% INPUT:
%   A: 2D matrix
% OUTPUT:
%   status: true if symmetric, false if not
%
% Example
% A=[1 2;2 9];
% nma_is_symmetric_matrix(A)
%      1
%
% A=[1 2+2*eps;2 9];
% nma_is_symmetric_matrix(A)
%      0
%
% copyright: Nasser M. Abbasi
% updated 10/26/2010


if ndims(A) > 2
   error('nma_is_symmetric_matrix::A number of dimensions too large');
end

[n,nCol]  = size(A);
if n ~= nCol
   error('nma_is_symmetric_matrix::input matrix A must be square');
end

r = triu(abs(A-A'),1);
if any(r(:,2:end))
   is_symmetric = false;
else
   is_symmetric = true;
end


end

