function varargout = nma_orbit_simulator(varargin)
%main GUI file for orbit simulator

% NMA_ORBIT_SIMULATOR M-file for nma_orbit_simulator.fig
%      NMA_ORBIT_SIMULATOR, by itself, creates a new NMA_ORBIT_SIMULATOR or raises the existing
%      singleton*.
%
%      H = NMA_ORBIT_SIMULATOR returns the handle to a new NMA_ORBIT_SIMULATOR or the handle to
%      the existing singleton*.
%
%      NMA_ORBIT_SIMULATOR('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in NMA_ORBIT_SIMULATOR.M with the given input arguments.
%
%      NMA_ORBIT_SIMULATOR('Property','Value',...) creates a new NMA_ORBIT_SIMULATOR or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before nma_orbit_simulator_OpeningFunction gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to nma_orbit_simulator_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help nma_orbit_simulator

% Last Modified by GUIDE v2.5 23-May-2012 22:19:03

% Begin initialization code - DO NOT EDIT

gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @nma_orbit_simulator_OpeningFcn, ...
                   'gui_OutputFcn',  @nma_orbit_simulator_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before nma_orbit_simulator is made visible.
function nma_orbit_simulator_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to nma_orbit_simulator (see VARARGIN)

% Choose default command line output for nma_orbit_simulator
handles.output = hObject;

% Update handles structure
guidata(hObject, handles);

% UIWAIT makes nma_orbit_simulator wait for user response (see UIRESUME)
% uiwait(handles.figure1);

%--- start my code.

   set(hObject,'Name','orbit_simulator. May 3, 2003. Nasser M. Abbasi. Free software');
   set(hObject,'NumberTitle','off');

h.stopRequested=0;

h.mainWindow_h=findobj(hObject,'Tag','figure1');

h.r0_I_h=findobj(hObject,'Tag','r0_I_tag');
h.r0_J_h=findobj(hObject,'Tag','r0_J_tag');
h.r0_k_h=findobj(hObject,'Tag','r0_k_tag');

h.v0_I_h=findobj(hObject,'Tag','v0_I_tag');
h.v0_J_h=findobj(hObject,'Tag','v0_J_tag');
h.v0_k_h=findobj(hObject,'Tag','v0_k_tag');

h.r_I_h=findobj(hObject,'Tag','r_I_tag');
h.r_J_h=findobj(hObject,'Tag','r_J_tag');
h.r_k_h=findobj(hObject,'Tag','r_k_tag');

h.v_I_h=findobj(hObject,'Tag','v_I_tag');
h.v_J_h=findobj(hObject,'Tag','v_J_tag');
h.v_k_h=findobj(hObject,'Tag','v_k_tag');


%h.problem1_h=findobj(hObject,'Tag','problem1_tag');
h.deltaTime_h=findobj(hObject,'Tag','deltaTime_tag');

h.problem2_h=findobj(hObject,'Tag','problem2_tag');
%h.deltaNu_h=findobj(hObject,'Tag','deltaNu_tag');

h.mu_h=findobj(hObject,'Tag','mu_tag');

h.tof_hr_h=findobj(hObject,'Tag','tof_hr_tag');
h.tof_min_h=findobj(hObject,'Tag','tof_min_tag');
h.tof_sec_h=findobj(hObject,'Tag','tof_sec_tag');

h.period_h=findobj(hObject,'Tag','period_tag');
h.e_h=findobj(hObject,'Tag','e_tag');
h.p_h=findobj(hObject,'Tag','p_tag');
h.a_h=findobj(hObject,'Tag','a_tag');
h.rp_vec_h=findobj(hObject,'Tag','rp_vec_tag');
h.c_h=findobj(hObject,'Tag','c_tag');
h.rp_h=findobj(hObject,'Tag','rp_tag');
h.ra_h=findobj(hObject,'Tag','ra_tag');
h.b_h=findobj(hObject,'Tag','b_tag');
h.ra_vec_h=findobj(hObject,'Tag','ra_vec_tag');
h.h_h=findobj(hObject,'Tag','h_tag');
h.E_h=findobj(hObject,'Tag','E_tag');
h.X_h=findobj(hObject,'Tag','X_tag');
h.type_h=findobj(hObject,'Tag','type_tag');
h.e_vec_h=findobj(hObject,'Tag','e_vec_tag');


h.nStep_h=findobj(hObject,'Tag','nStep_tag');
h.r_mag_h=findobj(hObject,'Tag','r_mag_tag');
h.v_mag_h=findobj(hObject,'Tag','v_mag_tag');
h.X_all_h=findobj(hObject,'Tag','X_all_tag');

zoom on;

set(hObject,'UserData',h);

% --- Outputs from this function are returned to the command line.
function varargout = nma_orbit_simulator_OutputFcn(hObject, eventdata, handles)
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;


% --- Executes during object creation, after setting all properties.
function r0_I_tag_CreateFcn(hObject, eventdata, handles)
% hObject    handle to r0_I_tag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end


function r0_I_tag_Callback(hObject, eventdata, handles)
% hObject    handle to r0_I_tag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of r0_I_tag as text
%        str2double(get(hObject,'String')) returns contents of r0_I_tag as a double


% --- Executes during object creation, after setting all properties.
function r0_J_tag_CreateFcn(hObject, eventdata, handles)
% hObject    handle to r0_J_tag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end


function r0_J_tag_Callback(hObject, eventdata, handles)
% hObject    handle to r0_J_tag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of r0_J_tag as text
%        str2double(get(hObject,'String')) returns contents of r0_J_tag as a double


% --- Executes during object creation, after setting all properties.
function r0_K_tag_CreateFcn(hObject, eventdata, handles)
% hObject    handle to r0_K_tag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function r0_K_tag_Callback(hObject, eventdata, handles)
% hObject    handle to r0_K_tag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of r0_K_tag as text
%        str2double(get(hObject,'String')) returns contents of r0_K_tag as a double


% --- Executes during object creation, after setting all properties.
function v0_I_tag_CreateFcn(hObject, eventdata, handles)
% hObject    handle to v0_I_tag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function v0_I_tag_Callback(hObject, eventdata, handles)
% hObject    handle to v0_I_tag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of v0_I_tag as text
%        str2double(get(hObject,'String')) returns contents of v0_I_tag as a double


% --- Executes during object creation, after setting all properties.
function v0_J_tag_CreateFcn(hObject, eventdata, handles)
% hObject    handle to v0_J_tag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function v0_J_tag_Callback(hObject, eventdata, handles)
% hObject    handle to v0_J_tag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of v0_J_tag as text
%        str2double(get(hObject,'String')) returns contents of v0_J_tag as a double


% --- Executes during object creation, after setting all properties.
function v0_K_tag_CreateFcn(hObject, eventdata, handles)
% hObject    handle to v0_K_tag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function v0_K_tag_Callback(hObject, eventdata, handles)
% hObject    handle to v0_K_tag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of v0_K_tag as text
%        str2double(get(hObject,'String')) returns contents of v0_K_tag as a double


% --- Executes during object creation, after setting all properties.
function mu_tag_CreateFcn(hObject, eventdata, handles)
% hObject    handle to mu_tag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function mu_tag_Callback(hObject, eventdata, handles)
% hObject    handle to mu_tag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of mu_tag as text
%        str2double(get(hObject,'String')) returns contents of mu_tag as a double


% --- Executes on button press in problem1_tag.
function problem1_tag_Callback(hObject, eventdata, handles)
% hObject    handle to problem1_tag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of problem1_tag

 [o,FF]=gcbo;       
 h=get(FF,'UserData');
 
   %if( get(h.problem1_h,'Value') == 1 )
   %   set(h.problem2_h,'Value',0);
   %   %set(h.deltaNu_h,'Enable','off');                      
   %   set(h.deltaTime_h,'Enable','on');
   %else
   %   set(h.problem2_h,'Value',1);
   %   %set(h.deltaNu_h,'Enable','on');                            
   %   set(h.deltaTime_h,'Enable','off');      
   %end               

    
% --- Executes on button press in problem2_tag.
function problem2_tag_Callback(hObject, eventdata, handles)
% hObject    handle to problem2_tag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of problem2_tag

[o,FF]=gcbo;       
 h=get(FF,'UserData');
 
   if( get(h.problem2_h,'Value') == 1 )
      set(h.problem1_h,'Value',0);
     % set(h.deltaNu_h,'Enable','on');
      set(h.deltaTime_h,'Enable','off');      
   else
      %set(h.deltaNu_h,'Enable','off');                            
      set(h.problem1_h,'Value',1);      
      set(h.deltaTime_h,'Enable','on');      
   end               


% --- Executes during object creation, after setting all properties.
function deltaTime_tag_CreateFcn(hObject, eventdata, handles)
% hObject    handle to deltaTime_tag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function deltaTime_tag_Callback(hObject, eventdata, handles)
% hObject    handle to deltaTime_tag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of deltaTime_tag as text
%        str2double(get(hObject,'String')) returns contents of deltaTime_tag as a double


% --- Executes during object creation, after setting all properties.
function deltaNu_tag_CreateFcn(hObject, eventdata, handles)
% hObject    handle to deltaNu_tag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end


function deltaNu_tag_Callback(hObject, eventdata, handles)
% hObject    handle to deltaNu_tag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of deltaNu_tag as text
%        str2double(get(hObject,'String')) returns contents of deltaNu_tag as a double


% --- Executes on button press in run_tag.
function run_tag_Callback(hObject, eventdata, handles)
% hObject    handle to run_tag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

 [o,FF]=gcbo;       
 h=get(FF,'UserData');
 
 % read screen input

 
 [r0_I,err]=getNumber(h.r0_I_h,'I component for r0');
 if(err)
     return;
 end
 
 [r0_J,err]=getNumber(h.r0_J_h,'J component for r0');
 if(err)
     return;
 end
 
 [r0_k,err]=getNumber(h.r0_k_h,'K component for r0');
 if(err)
     return;
 end
 
 [v0_I,err]=getNumber(h.v0_I_h,'I component for v0');
 if(err)
     return;
 end
 
 [v0_J,err]=getNumber(h.v0_J_h,'J component for v0');
 if(err)
     return;
 end
 
 [v0_k,err]=getNumber(h.v0_k_h,'k component for v0');
 if(err)
     return;
 end

 [mu,err]=getNumber(h.mu_h,'mu');
 if(err)
     return;
 end

 r0_vec=[r0_I r0_J r0_k];
 v0_vec=[v0_I v0_J v0_k];
 
 [deltaTime,err]=getNumber(h.deltaTime_h,'delta time');
 
%  if(get(h.problem1_h,'Value')==1)
%      [deltaTime,err]=getNumber(h.deltaTime_h,'delta time');
%      if(err)
%          return;
%      end
%  else
%      deltaNu=60;
%      %[deltaNu,err]=getNumber(h.deltaNu_h,'delta nu');
%      %if(err)
%      %    return;
%      %end    
%      deltaNu = deltaNu * (pi/180);
%   
%      [deltaTime,err]=nma_getDeltaTimeFromDeltaNu(r0_vec,v0_vec,0,deltaNu,mu);
%      if(~isempty(err))
%         uiwait(errordlg(sprintf('%s',err)));
%         return;              
%      end
%      deltaTime=deltaTime/(1.239446309*10^-3);  % now seconds
%      deltaTime=deltaTime/(60*60);  %now hrs
%      
%  end

 [nSteps,err]=getNumber(h.nStep_h,'simulation steps');
 if(err)
     return;
 end
 if(nSteps<=0)
     uiwait(errordlg('simulation steps must be greater than zero'));
     return;     
 end
     
 r0_vec=[r0_I r0_J r0_k];
 v0_vec=[v0_I v0_J v0_k];
 
 h_vec   = cross(r0_vec,v0_vec);
 if( abs(norm(h_vec))<eps)
     uiwait(errordlg('Initial state shows angular momentun to be zero. Invalid for a conic orbit. please try again.'));
     return;     
 end
 
 set(FF,'UserData',h);
 initScreen;
 process(r0_vec,v0_vec,deltaTime,nSteps,mu,handles);
    
% --- Executes during object creation, after setting all properties.
function r_I_tag_CreateFcn(hObject, eventdata, handles)
% hObject    handle to r_I_tag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end

function r_I_tag_Callback(hObject, eventdata, handles)
% hObject    handle to r_I_tag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of r_I_tag as text
%        str2double(get(hObject,'String')) returns contents of r_I_tag as a double


% --- Executes during object creation, after setting all properties.
function r_J_tag_CreateFcn(hObject, eventdata, handles)
% hObject    handle to r_J_tag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end

function r_J_tag_Callback(hObject, eventdata, handles)
% hObject    handle to r_J_tag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of r_J_tag as text
%        str2double(get(hObject,'String')) returns contents of r_J_tag as a double

% --- Executes during object creation, after setting all properties.
function r_K_tag_CreateFcn(hObject, eventdata, handles)
% hObject    handle to r_K_tag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function r_K_tag_Callback(hObject, eventdata, handles)
% hObject    handle to r_K_tag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of r_K_tag as text
%        str2double(get(hObject,'String')) returns contents of r_K_tag as a double


% --- Executes during object creation, after setting all properties.
function v_I_tag_CreateFcn(hObject, eventdata, handles)
% hObject    handle to v_I_tag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function v_I_tag_Callback(hObject, eventdata, handles)
% hObject    handle to v_I_tag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of v_I_tag as text
%        str2double(get(hObject,'String')) returns contents of v_I_tag as a double


% --- Executes during object creation, after setting all properties.
function v_J_tag_CreateFcn(hObject, eventdata, handles)
% hObject    handle to v_J_tag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function v_J_tag_Callback(hObject, eventdata, handles)
% hObject    handle to v_J_tag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of v_J_tag as text
%        str2double(get(hObject,'String')) returns contents of v_J_tag as a double


% --- Executes during object creation, after setting all properties.
function v_K_tag_CreateFcn(hObject, eventdata, handles)
% hObject    handle to v_K_tag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function v_K_tag_Callback(hObject, eventdata, handles)
% hObject    handle to v_K_tag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of v_K_tag as text
%        str2double(get(hObject,'String')) returns contents of v_K_tag as a double


% --- Executes during object creation, after setting all properties.
function tof_hr_tag_CreateFcn(hObject, eventdata, handles)
% hObject    handle to tof_hr_tag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function tof_hr_tag_Callback(hObject, eventdata, handles)
% hObject    handle to tof_hr_tag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of tof_hr_tag as text
%        str2double(get(hObject,'String')) returns contents of tof_hr_tag as a double


% --- Executes during object creation, after setting all properties.
function tof_min_tag_CreateFcn(hObject, eventdata, handles)
% hObject    handle to tof_min_tag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end


function tof_min_tag_Callback(hObject, eventdata, handles)
% hObject    handle to tof_min_tag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of tof_min_tag as text
%        str2double(get(hObject,'String')) returns contents of tof_min_tag as a double


% --- Executes during object creation, after setting all properties.
function tof_sec_tag_CreateFcn(hObject, eventdata, handles)
% hObject    handle to tof_sec_tag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end


function tof_sec_tag_Callback(hObject, eventdata, handles)
% hObject    handle to tof_sec_tag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of tof_sec_tag as text
%        str2double(get(hObject,'String')) returns contents of tof_sec_tag as a double


% --- Executes on button press in orbitParams_tag.
function orbitParams_tag_Callback(hObject, eventdata, handles)
% hObject    handle to orbitParams_tag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

[o,FF]=gcbo;       
h=get(FF,'UserData');
 
TRUE=1;
FALSE=0;

 [r0_I,err]=getNumber(h.r0_I_h,'I component for r0');
 if(err)
     return;
 end
 
 [r0_J,err]=getNumber(h.r0_J_h,'J component for r0');
 if(err)
     return;
 end
 
 [r0_k,err]=getNumber(h.r0_k_h,'K component for r0');
 if(err)
     return;
 end
 
 [v0_I,err]=getNumber(h.v0_I_h,'I component for v0');
 if(err)
     return;
 end
 
 [v0_J,err]=getNumber(h.v0_J_h,'J component for v0');
 if(err)
     return;
 end
 
 [v0_k,err]=getNumber(h.v0_k_h,'k component for v0');
 if(err)
     return;
 end

 [mu,err]=getNumber(h.mu_h,'mu');
 if(err)
     return;
 end

 r0_vec=[r0_I r0_J r0_k];
 v0_vec=[v0_I v0_J v0_k];
 
 if(get(h.problem1_h,'Value')==1)
     [deltaTime,err]=getNumber(h.deltaTime_h,'delta time');
     if(err)
         return;
     end
 else
     [deltaNu,err]=getNumber(h.deltaNu_h,'delta nu');
     if(err)
         return;
     end    
     deltaNu = deltaNu * (pi/180);
  
     [deltaTime,err]=nma_getDeltaTimeFromDeltaNu(r0_vec,v0_vec,0,deltaNu,mu);
     if(~isempty(err))
        uiwait(errordlg(sprintf('%s',err)));
        return;              
     end
     deltaTime=deltaTime/(1.239446309*10^-3);  % now seconds
     deltaTime=deltaTime/(60*60);  %now hrs
     
 end

 [nSteps,err]=getNumber(h.nStep_h,'simulation steps');
 if(err)
     return;
 end
 if(nSteps<=0)
     uiwait(errordlg('simulation steps must be greater than zero'));
     return;     
 end
     

 r0_vec=[r0_I r0_J r0_k];
 v0_vec=[v0_I v0_J v0_k];
 
 h_vec   = cross(r0_vec,v0_vec);
 if( abs(norm(h_vec))<eps)
     uiwait(errordlg('Initial state shows angular momentun to be zero. Invalid for a conic orbit. please try again.'));
     return;     
 end
 
 initScreen;
 
TC=1.239446309*10^-3;
simulationTime = deltaTime*60*60*TC;

time_ = linspace(0,simulationTime,nSteps);
if(length(time_)==1)
    timeStepDuration=1;
else
   timeStepDuration = time_(2)-time_(1);
end

rx = zeros(length(time_),1);
ry = rx;
rz = rx;

vx = rx;
vy = rx;
vz = rx;

X_=rx;
X_(1)=0;

rx(1)=r0_vec(1);
ry(1)=r0_vec(2);
rz(1)=r0_vec(3);
vx(1)=v0_vec(1);
vy(1)=v0_vec(2);
vz(1)=v0_vec(3);

%find overall X 
[z1,z2,z3]=nma_moveProbe(r0_vec,v0_vec,simulationTime,mu);
set(h.X_all_h,'String',sprintf('%12.6f',z3));

o=nma_getOrbitParams(r0_vec,v0_vec,mu);
e=norm(o.e_vec);

if(e<1)
  periodInMin  = o.period*13.44686457;
  periodHrs    = floor(periodInMin/60);
  periodMins   = periodInMin-(periodHrs*60);
  set(h.period_h,'String',sprintf('%4.0f hr:%2.0f min',periodHrs,periodMins));  
else
  set(h.period_h,'String','N/A');      
end
 
set(h.e_h,'String',sprintf('%6.2f',norm(o.e_vec)));
set(h.p_h,'String',sprintf('%6.2f',o.p));
set(h.a_h,'String',sprintf('%6.2f',o.a));
set(h.c_h,'String',sprintf('%6.2f',o.c));
set(h.rp_h,'String',sprintf('%6.2f',o.rp));
set(h.ra_h,'String',sprintf('%6.2f',o.ra));
set(h.h_h,'String',sprintf('%6.2f',norm(o.h_vec)));
set(h.E_h,'String',sprintf('%6.2f',o.energy));
if(abs(e)<0.0001) %eps)
    type='CIRCLE';
elseif(e>0.0001 && e<0.9999)
    type='ELLIPS';
elseif(abs(e-1)<eps)
    type='PARABOLA';
else
    type='HYPARABOLA';
end

set(h.rp_vec_h,'String',sprintf('%6.2f, %6.2f, %6.2f',o.rp_vec(1),o.rp_vec(2),o.rp_vec(3)));
set(h.e_vec_h,'String',sprintf('%6.2f, %6.2f, %6.2f',o.e_vec(1),o.e_vec(2),o.e_vec(3)));

if(e<1)
   set(h.rp_vec_h,'String',sprintf('%6.2f, %6.2f, %6.2f',o.rp_vec(1),o.rp_vec(2),o.rp_vec(3)));    
else
   set(h.ra_vec_h,'String','N/A');        
end
 
for i=2:length(time_)-1
    [r_vec,v_vec,X] = nma_moveProbe(r0_vec,v0_vec,timeStepDuration,mu);    
    
    rx(i)=r_vec(1);
    ry(i)=r_vec(2);
    rz(i)=r_vec(3);
    
    vx(i)=v_vec(1);
    vy(i)=v_vec(2);
    vz(i)=v_vec(3);
    
    X_(i)=X;
    
    r0_vec=r_vec;
    v0_vec=v_vec;    
end

set(h.type_h,'String',type);

set(FF,'userData',h);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [v,err]=getNumber(h,s)

err=0;

 v  = get(h,'String');
 v  = str2double( v );
 if( isnan( v ) )
     uiwait(errordlg(sprintf('Invalid numeric value for %s',s)));
     err=1;
     return;
 end
 
%%%%%%%%%%%%%%%%%%%%%%%%
function process(r0_vec,v0_vec,simulationTime,nSteps,mu,handles)

[~,FF]=gcbo;       
userData=get(FF,'UserData');

userData.stopRequested=0;
set(FF,'userData',userData);

mainWindow_h = userData.mainWindow_h;


TRUE=1;
FALSE=0;
 
TC=1.239446309*10^-3;
simulationTime = simulationTime*60*60*TC;

time_ = linspace(0,simulationTime,nSteps);
if(length(time_)==1)
    timeStepDuration=1;
else
   timeStepDuration = time_(2)-time_(1);
end

rx = zeros(length(time_),1);
ry = rx;
rz = rx;

vx = rx;
vy = rx;
vz = rx;

X_=rx;
X_(1)=0;

rx(1)=r0_vec(1);
ry(1)=r0_vec(2);
rz(1)=r0_vec(3);
vx(1)=v0_vec(1);
vy(1)=v0_vec(2);
vz(1)=v0_vec(3);

%find overall X 
[z1,z2,z3]=nma_moveProbe(r0_vec,v0_vec,simulationTime,mu);
set(userData.X_all_h,'String',sprintf('%12.6f',z3));

o=nma_getOrbitParams(r0_vec,v0_vec,mu);
e=norm(o.e_vec);

if(e<1)
  periodInMin  = o.period*13.44686457;
  periodHrs    = floor(periodInMin/60);
  periodMins   = periodInMin-(periodHrs*60);
  set(userData.period_h,'String',sprintf('%4.0f hr:%2.0f min',periodHrs,periodMins));  
else
  set(userData.period_h,'String','N/A');      
end
 
set(userData.e_h,'String',sprintf('%6.2f',norm(o.e_vec)));
set(userData.p_h,'String',sprintf('%6.2f',o.p));
set(userData.a_h,'String',sprintf('%6.2f',o.a));
set(userData.c_h,'String',sprintf('%6.2f',o.c));
set(userData.rp_h,'String',sprintf('%6.2f',o.rp));
set(userData.ra_h,'String',sprintf('%6.2f',o.ra));
set(userData.h_h,'String',sprintf('%6.2f',norm(o.h_vec)));
set(userData.E_h,'String',sprintf('%6.2f',o.energy));
if(abs(e)<0.0001) %eps)
    type='CIRCLE';
elseif(e>0.0001 && e<0.9999)
    type='ELLIPS';
elseif(abs(e-1)<eps)
    type='PARABOLA';
else
    type='HYPARABOLA';
end
 
set(userData.rp_vec_h,'String',sprintf('%6.2f, %6.2f, %6.2f',o.rp_vec(1),o.rp_vec(2),o.rp_vec(3)));
set(userData.e_vec_h,'String',sprintf('%6.2f, %6.2f, %6.2f',o.e_vec(1),o.e_vec(2),o.e_vec(3)));

if(e<1)
   set(userData.rp_vec_h,'String',sprintf('%6.2f, %6.2f, %6.2f',o.rp_vec(1),o.rp_vec(2),o.rp_vec(3)));    
else
   set(userData.ra_vec_h,'String','N/A');        
end
 
for i=2:length(time_)-1

    drawnow();
    [r_vec,v_vec,X] = nma_moveProbe(r0_vec,v0_vec,timeStepDuration,mu);    
    
    rx(i)=r_vec(1);
    ry(i)=r_vec(2);
    rz(i)=r_vec(3);
    
    vx(i)=v_vec(1);
    vy(i)=v_vec(2);
    vz(i)=v_vec(3);
    
    X_(i)=X;
    
    r0_vec=r_vec;
    v0_vec=v_vec;    
end

cla(handles.main_axes, 'reset');
set(gcf, 'CurrentAxes', handles.main_axes);
set(gca,'FontSize',7);
set(handles.main_axes,'FontSize',7);

%%%%%%%%%%%%% userData.axes1_h;         
%%%%%%%%%%%% set(FF,'CurrentAxes',handle);
%%%%%%%%%%%% delete(get(handle,'Children'));
 
% enable double buffering to reduce flickering.
set(gcf,'DoubleBuffer','on')
 
maxX=max(rx);
maxY=max(ry);
maxZ=max(rz);

maxDim=max([maxX maxY maxZ]);
maxDim=maxDim+maxDim*0.2;

startX=-maxDim;
endX=maxDim;
startY=-maxDim;
endY=maxDim;
startZ=-maxDim;
endZ=maxDim;

plot3(0,0,0,'*');

hold on;

plot3([0 0],[0 0],[startZ endZ]); 
plot3([startX endX],[0 0],[0 0]); 
plot3([0 0],[startY endY],[0 0]);
text(0,endY+0.05*endY,0,'J'); 
text(endX+0.05*endX,0,0,'I') ; 
text(0,0,endZ+0.05*endZ,'K')
view(107,48)

set(userData.type_h,'String',type);
       
h_radialLine = 0;
h_probe=0;
timeThisCycle=0;

%plot3(0,0,0,'*');
%hold on;

plot3( [0;o.rp_vec(1)] ,  [0;o.rp_vec(2)] ,  [0;o.rp_vec(3)],'k-');
text(o.rp_vec(1)/2 ,  o.rp_vec(2)/2 ,  o.rp_vec(3)/2,'rp');

%only pot ra for ellips and circle
if(e<1)
    set(0,'Currentfigure',handle);    
    plot3( [0;o.ra_vec(1)] ,  [0;o.ra_vec(2)] ,  [0;o.ra_vec(3)],'m-');
%   Plot3AxisAtOrigin([0;o.ra_vec(1)] ,  [0;o.ra_vec(2)] ,  [0;o.ra_vec(3)],'m-');
    text( o.ra_vec(1)/2 ,  o.ra_vec(2)/2 ,  o.ra_vec(3)/2,'ra');
end

%view(20,30);
%xlabel('x-axis');
%ylabel('y-axis');
%zlabel('z-axis');
keepPlottingTrace=TRUE;

for i=1:length(rx)-1

    set(handles.currentStepNumber,'String',num2str(i));
    
    userData=get(FF,'UserData');
    if(userData.stopRequested)
        userData.stopRequested=0;
        set(FF,'UserData',userData);
        return;
    end
    
    if(h_radialLine ~= 0 )
        delete(h_radialLine);
        h_radialLine=0;
    end
    
    h_radialLine=plot3([0; rx(i)] , [0;ry(i)] , [0;rz(i)],'r'); % shows radial vector from origin.    
   
    if(keepPlottingTrace)
        plot3( rx(i) ,  ry(i) ,  rz(i),'+');
        %Plot3AxisAtOrigin( rx(i) ,  ry(i) ,  rz(i),'+');        
    end    
    
    if(h_probe ~=0)
         delete(h_probe);
%        delete(h_vline);
    end    

    h_probe=plot3( rx(i) ,  ry(i) ,  rz(i),'o');
    %Plot3AxisAtOrigin( rx(i) ,  ry(i) ,  rz(i),'+');        
        
    currentTime  = i*timeStepDuration;
    currentTime  = (currentTime/TC);  %back to secs
    nhrs         = floor(currentTime/(60*60));
    nmin         = floor(  (currentTime- nhrs*60*60)/60 );
    nsec         = currentTime - ( (nhrs*60*60)+nmin*60 );
    
    set(userData.tof_hr_h,'String',nhrs);      
    set(userData.tof_min_h,'String',nmin);      
    set(userData.tof_sec_h,'String',sprintf('%2.0f',nsec));      
    
    set(userData.r_I_h,'String',sprintf('%6.2f',rx(i)));
    set(userData.r_J_h,'String',sprintf('%6.2f',ry(i)));
    set(userData.r_k_h,'String',sprintf('%6.2f',rz(i)));
    set(userData.v_I_h,'String',sprintf('%6.2f',vx(i)));
    set(userData.v_J_h,'String',sprintf('%6.2f',vy(i)));
    set(userData.v_k_h,'String',sprintf('%6.2f',vz(i)));
    set(userData.X_h,'String',X_(i));
    set(userData.r_mag_h,'String',norm([rx(i) ry(i) rz(i)]));
    set(userData.v_mag_h,'String',norm([vx(i) vy(i) vz(i)]));

    drawnow;
    
    timeThisCycle = timeThisCycle + timeStepDuration;
    if(abs(real(o.period)) >eps)
        if(timeThisCycle >= real(o.period) )
            timeThisCycle=0;
            keepPlottingTrace=FALSE;
        end
    end
end


% --- Executes during object creation, after setting all properties.
function r0_k_tag_CreateFcn(hObject, eventdata, handles)
% hObject    handle to r0_k_tag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end


function r0_k_tag_Callback(hObject, eventdata, handles)
% hObject    handle to r0_k_tag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of r0_k_tag as text
%        str2double(get(hObject,'String')) returns contents of r0_k_tag as a double


% --- Executes during object creation, after setting all properties.
function v0_k_tag_CreateFcn(hObject, eventdata, handles)
% hObject    handle to v0_k_tag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function v0_k_tag_Callback(hObject, eventdata, handles)
% hObject    handle to v0_k_tag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of v0_k_tag as text
%        str2double(get(hObject,'String')) returns contents of v0_k_tag as a double


% --- Executes during object creation, after setting all properties.
function r_k_tag_CreateFcn(hObject, eventdata, handles)
% hObject    handle to r_k_tag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function r_k_tag_Callback(hObject, eventdata, handles)
% hObject    handle to r_k_tag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of r_k_tag as text
%        str2double(get(hObject,'String')) returns contents of r_k_tag as a double


% --- Executes during object creation, after setting all properties.
function v_k_tag_CreateFcn(hObject, eventdata, handles)
% hObject    handle to v_k_tag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function v_k_tag_Callback(hObject, eventdata, handles)
% hObject    handle to v_k_tag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of v_k_tag as text
%        str2double(get(hObject,'String')) returns contents of v_k_tag as a double


% --- Executes during object creation, after setting all properties.
function period_tag_CreateFcn(hObject, eventdata, handles)
% hObject    handle to period_tag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function period_tag_Callback(hObject, eventdata, handles)
% hObject    handle to period_tag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of period_tag as text
%        str2double(get(hObject,'String')) returns contents of period_tag as a double


% --- Executes during object creation, after setting all properties.
function e_tag_CreateFcn(hObject, eventdata, handles)
% hObject    handle to e_tag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function e_tag_Callback(hObject, eventdata, handles)
% hObject    handle to e_tag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of e_tag as text
%        str2double(get(hObject,'String')) returns contents of e_tag as a double


% --- Executes during object creation, after setting all properties.
function p_tag_CreateFcn(hObject, eventdata, handles)
% hObject    handle to p_tag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function p_tag_Callback(hObject, eventdata, handles)
% hObject    handle to p_tag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of p_tag as text
%        str2double(get(hObject,'String')) returns contents of p_tag as a double


% --- Executes during object creation, after setting all properties.
function a_tag_CreateFcn(hObject, eventdata, handles)
% hObject    handle to a_tag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function a_tag_Callback(hObject, eventdata, handles)
% hObject    handle to a_tag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of a_tag as text
%        str2double(get(hObject,'String')) returns contents of a_tag as a double


% --- Executes during object creation, after setting all properties.
function edit23_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit23 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function edit23_Callback(hObject, eventdata, handles)
% hObject    handle to edit23 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit23 as text
%        str2double(get(hObject,'String')) returns contents of edit23 as a double


% --- Executes during object creation, after setting all properties.
function edit24_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit24 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function edit24_Callback(hObject, eventdata, handles)
% hObject    handle to edit24 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit24 as text
%        str2double(get(hObject,'String')) returns contents of edit24 as a double


% --- Executes during object creation, after setting all properties.
function edit25_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit25 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function edit25_Callback(hObject, eventdata, handles)
% hObject    handle to edit25 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit25 as text
%        str2double(get(hObject,'String')) returns contents of edit25 as a double


% --- Executes during object creation, after setting all properties.
function b_tag_CreateFcn(hObject, eventdata, handles)
% hObject    handle to b_tag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function b_tag_Callback(hObject, eventdata, handles)
% hObject    handle to b_tag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of b_tag as text
%        str2double(get(hObject,'String')) returns contents of b_tag as a double


% --- Executes during object creation, after setting all properties.
function edit27_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit27 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function edit27_Callback(hObject, eventdata, handles)
% hObject    handle to edit27 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit27 as text
%        str2double(get(hObject,'String')) returns contents of edit27 as a double


% --- Executes during object creation, after setting all properties.
function edit28_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit28 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function edit28_Callback(hObject, eventdata, handles)
% hObject    handle to edit28 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit28 as text
%        str2double(get(hObject,'String')) returns contents of edit28 as a double


% --- Executes during object creation, after setting all properties.
function X_tag_CreateFcn(hObject, eventdata, handles)
% hObject    handle to X_tag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function X_tag_Callback(hObject, eventdata, handles)
% hObject    handle to X_tag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of X_tag as text
%        str2double(get(hObject,'String')) returns contents of X_tag as a double


% --- Executes during object creation, after setting all properties.
function edit30_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit30 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function edit30_Callback(hObject, eventdata, handles)
% hObject    handle to edit30 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit30 as text
%        str2double(get(hObject,'String')) returns contents of edit30 as a double


% --- Executes during object creation, after setting all properties.
function edit31_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit31 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function edit31_Callback(hObject, eventdata, handles)
% hObject    handle to edit31 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit31 as text
%        str2double(get(hObject,'String')) returns contents of edit31 as a double


% --- Executes during object creation, after setting all properties.
function edit32_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit32 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function edit32_Callback(hObject, eventdata, handles)
% hObject    handle to edit32 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit32 as text
%        str2double(get(hObject,'String')) returns contents of edit32 as a double


% --- Executes during object creation, after setting all properties.
function ra_vec_tag_CreateFcn(hObject, eventdata, handles)
% hObject    handle to ra_vec_tag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function ra_vec_tag_Callback(hObject, eventdata, handles)
% hObject    handle to ra_vec_tag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of ra_vec_tag as text
%        str2double(get(hObject,'String')) returns contents of ra_vec_tag as a double


% --- Executes during object creation, after setting all properties.
function type_tag_CreateFcn(hObject, eventdata, handles)
% hObject    handle to type_tag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function type_tag_Callback(hObject, eventdata, handles)
% hObject    handle to type_tag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of type_tag as text
%        str2double(get(hObject,'String')) returns contents of type_tag as a double


% --- Executes during object creation, after setting all properties.
function e_vec_tag_CreateFcn(hObject, eventdata, handles)
% hObject    handle to e_vec_tag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function e_vec_tag_Callback(hObject, eventdata, handles)
% hObject    handle to e_vec_tag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of e_vec_tag as text
%        str2double(get(hObject,'String')) returns contents of e_vec_tag as a double


% --- Executes during object creation, after setting all properties.
function rp_vec_tag_CreateFcn(hObject, eventdata, handles)
% hObject    handle to rp_vec_tag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function rp_vec_tag_Callback(hObject, eventdata, handles)
% hObject    handle to rp_vec_tag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of rp_vec_tag as text
%        str2double(get(hObject,'String')) returns contents of rp_vec_tag as a double


% --- Executes during object creation, after setting all properties.
function c_tag_CreateFcn(hObject, eventdata, handles)
% hObject    handle to c_tag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function c_tag_Callback(hObject, eventdata, handles)
% hObject    handle to c_tag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of c_tag as text
%        str2double(get(hObject,'String')) returns contents of c_tag as a double


% --- Executes during object creation, after setting all properties.
function rp_tag_CreateFcn(hObject, eventdata, handles)
% hObject    handle to rp_tag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function rp_tag_Callback(hObject, eventdata, handles)
% hObject    handle to rp_tag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of rp_tag as text
%        str2double(get(hObject,'String')) returns contents of rp_tag as a double


% --- Executes during object creation, after setting all properties.
function ra_tag_CreateFcn(hObject, eventdata, handles)
% hObject    handle to ra_tag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function ra_tag_Callback(hObject, eventdata, handles)
% hObject    handle to ra_tag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of ra_tag as text
%        str2double(get(hObject,'String')) returns contents of ra_tag as a double


% --- Executes during object creation, after setting all properties.
function h_tag_CreateFcn(hObject, eventdata, handles)
% hObject    handle to h_tag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function h_tag_Callback(hObject, eventdata, handles)
% hObject    handle to h_tag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of h_tag as text
%        str2double(get(hObject,'String')) returns contents of h_tag as a double


% --- Executes during object creation, after setting all properties.
function E_tag_CreateFcn(hObject, eventdata, handles)
% hObject    handle to E_tag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function E_tag_Callback(hObject, eventdata, handles)
% hObject    handle to E_tag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of E_tag as text
%        str2double(get(hObject,'String')) returns contents of E_tag as a double


% --- Executes during object creation, after setting all properties.
function nStep_tag_CreateFcn(hObject, eventdata, handles)
% hObject    handle to nStep_tag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function nStep_tag_Callback(hObject, eventdata, handles)
% hObject    handle to nStep_tag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of nStep_tag as text
%        str2double(get(hObject,'String')) returns contents of nStep_tag as a double


% --- Executes during object creation, after setting all properties.
function r_mag_tag_CreateFcn(hObject, eventdata, handles)
% hObject    handle to r_mag_tag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function r_mag_tag_Callback(hObject, eventdata, handles)
% hObject    handle to r_mag_tag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of r_mag_tag as text
%        str2double(get(hObject,'String')) returns contents of r_mag_tag as a double


% --- Executes during object creation, after setting all properties.
function v_mag_tag_CreateFcn(hObject, eventdata, handles)
% hObject    handle to v_mag_tag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function v_mag_tag_Callback(hObject, eventdata, handles)
% hObject    handle to v_mag_tag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of v_mag_tag as text
%        str2double(get(hObject,'String')) returns contents of v_mag_tag as a double


% --- Executes during object creation, after setting all properties.
function X_all_tag_CreateFcn(hObject, eventdata, handles)
% hObject    handle to X_all_tag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function X_all_tag_Callback(hObject, eventdata, handles)
% hObject    handle to X_all_tag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of X_all_tag as text
%        str2double(get(hObject,'String')) returns contents of X_all_tag as a double


%%%%%%%%%%%%%%%%%%%%%%%%
%
%
%%%%%%%%%%%%%%%%%%%%%%%%%
function initScreen(h)

 [o,FF]=gcbo;       
 h=get(FF,'UserData');
 
set(h.r_I_h,'String','');
set(h.r_J_h,'String','');
set(h.r_k_h,'String','');

set(h.v_I_h,'String','');
set(h.v_J_h,'String','');
set(h.v_k_h,'String','');


set(h.tof_hr_h,'String','');
set(h.tof_min_h,'String','');
set(h.tof_sec_h,'String','');

set(h.period_h,'String','');
set(h.e_h,'String','');
set(h.p_h,'String','');
set(h.a_h,'String','');
set(h.rp_vec_h,'String','');
set(h.c_h,'String','');
set(h.rp_h,'String','');
set(h.ra_h,'String','');
set(h.b_h,'String','');
set(h.ra_vec_h,'String','');
set(h.h_h,'String','');
set(h.E_h,'String','');
set(h.X_h,'String','');
set(h.type_h,'String','');
set(h.e_vec_h,'String','');

set(h.r_mag_h,'String','');
set(h.v_mag_h,'String','');
set(h.X_all_h,'String','');

 set(FF,'UserData',h);



% --- Executes on button press in stop.
function stop_Callback(hObject, eventdata, handles)
% hObject    handle to stop (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

 [o,FF]=gcbo;       
 h=get(FF,'UserData');

 h.stopRequested=1;
 
set(FF,'UserData',h);




function currentStepNumber_Callback(hObject, eventdata, handles)
% hObject    handle to currentStepNumber (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of currentStepNumber as text
%        str2double(get(hObject,'String')) returns contents of currentStepNumber as a double


% --- Executes during object creation, after setting all properties.
function currentStepNumber_CreateFcn(hObject, eventdata, handles)
% hObject    handle to currentStepNumber (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end
