function varargout = nma_modal_v2(varargin)
%solves 3 bars and 2 springs with IC using modal based solution

% NMA_MODAL_V2 MATLAB code for nma_modal_v2.fig
%      NMA_MODAL_V2, by itself, creates a new NMA_MODAL_V2 or raises the existing
%      singleton*.
%
%      H = NMA_MODAL_V2 returns the handle to a new NMA_MODAL_V2 or the handle to
%      the existing singleton*.
%
%      NMA_MODAL_V2('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in NMA_MODAL_V2.M with the given input arguments.
%
%      NMA_MODAL_V2('Property','Value',...) creates a new NMA_MODAL_V2 or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before nma_modal_v2_OpeningFcn gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to nma_modal_v2_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help nma_modal_v2

% Last Modified by GUIDE v2.5 14-May-2013 03:25:03

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
    'gui_Singleton',  gui_Singleton, ...
    'gui_OpeningFcn', @nma_modal_v2_OpeningFcn, ...
    'gui_OutputFcn',  @nma_modal_v2_OutputFcn, ...
    'gui_LayoutFcn',  [] , ...
    'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before nma_modal_v2 is made visible.
function nma_modal_v2_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to nma_modal_v2 (see VARARGIN)

% Choose default command line output for nma_modal_v2
handles.output = hObject;

data.state       = 'run';
data.k1 = get(handles.k1_slider,'Value');
data.k2 = get(handles.k2_slider,'Value');

data.m1 = 1; %get(handles.m1_slider,'Value');
data.m2 = 1; %get(handles.m2_slider,'Value');
data.m3 = 1; %get(handles.m3_slider,'Value');

data.axis_type = 'normal';

g=9.8;
data.K = [data.k1+0.5*data.m1*g -data.k1 0;-data.k1 data.k1+data.k2+0.5*data.m2*g -data.k2;0 -data.k2 data.k2+0.5*data.m3*g];

data.M = [data.m1 0 0;0 data.m2 0;0 0 data.m3];
data.max_time = get(handles.max_sim_time_slider,'Value');
data.delT = get(handles.delT,'Value');


data.theta1 = 45*pi/180;
data.theta2 = 0;
data.theta3 = 0;

data.mode1 = 1;
data.mode2 = 1;
data.mode3 = 1;

set(handles.figure1, 'UserData',data);
set(handles.figure1,'Name','Ver. 5/14/13. UW Madison, EMA 545, spring 2013. by Nasser M. Abbasi');


handles.laxis = axes('parent',hObject,'units','normalized','position',[0 0 1 1],'visible','off');
% Find all static text UICONTROLS whose 'Tag' starts with latex_
lbls = findobj(hObject,'-regexp','tag','latex_*');
for i=1:length(lbls)
l = lbls(i);
% Get current text, position and tag
set(l,'units','normalized');
s = get(l,'string');
p = get(l,'position');
t = get(l,'tag');
% Remove the UICONTROL
delete(l);
% Replace it with a TEXT object
handles.(t) = text(p(1),p(2),s,'interpreter','latex');
end

guidata(hObject, handles);

reset_axes(handles)
make_one_plot(data.theta1,data.theta2,data.theta3,1,2,data.axis_type,0,data.max_time);

% UIWAIT makes nma_modal_v2 wait for user response (see UIRESUME)
% uiwait(handles.figure1);


% --- Outputs from this function are returned to the command line.
function varargout = nma_modal_v2_OutputFcn(hObject, eventdata, handles)
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;


% --- Executes on button press in run_btn.
function run_btn_Callback(hObject, eventdata, handles)
% hObject    handle to run_btn (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

L = 1;
W = 2*L;
N = 3;

data = get(handles.figure1, 'UserData');
data.state = 'run';
set(handles.figure1, 'UserData',data);

K = data.K;
M = data.M;
[eigV,Lam] = obtain_solution(handles,K,M);
set(handles.figure1, 'CurrentAxes',handles.axes1);
cla;
title(make_title(Lam,eigV),'interpreter','latex','FontSize',12);

syms t;
solutionInPhysical =  sym(zeros(N, 1));

eta0   = eigV.'*M*[data.theta1;data.theta2;data.theta3];
eta    = [eta0(1)*cos(Lam(1)*t);eta0(2)*cos(Lam(2)*t);eta0(3)*cos(Lam(3)*t)];


if data.mode1 == 0
   eta(1) = 0;
end

if data.mode2 == 0
   eta(2) = 0;
end

if data.mode3 == 0
   eta(3) = 0;
end


solutionInPhysical = eigV*eta;

set(handles.latex_solution,'String',sprintf('$%s = %s$\n$%s = %s$\n$%s = %s$','\theta_1(t)',...
    char(vpa(solutionInPhysical(1),3)),...
    '\theta_2(t)',char(vpa(solutionInPhysical(2),3)),...
    '\theta_3(t)',char(vpa(solutionInPhysical(3),3))));

line([-0.2 2*W+0.2],[0 0]);
%title( makeTitle(a1,Lam,solutionPhi),'interpreter','latex','FontSize',12);

%setup the springs, function from Matlab file exchange, below
springcoord( [ 0 -L ] , [ W -L ], 10, 8, .2);
springcoord( [ W -L ] , [ 2*W -L ], 10, 8, .2);

i=0;
while i<data.max_time && strcmp(data.state,'run')
    
    theta1 = double(subs(solutionInPhysical(1),t,i));
    theta2 = double(subs(solutionInPhysical(2),t,i));
    theta3 = double(subs(solutionInPhysical(3),t,i));
    
    [h1,h2,h3,h4,h5] = make_one_plot(theta1,theta2,theta3,L,W,data.axis_type,i,data.max_time);
    drawnow;
    data = get(handles.figure1, 'UserData');
    if (i+data.delT)<data.max_time && strcmp(data.state,'run')
        delete(h1);
        delete(h2); delete(h3); delete(h4); delete(h5);
    end
    i = i + data.delT;
end


set(handles.figure1, 'UserData',data);

%-------------------------------
function [eigV,Lam]=obtain_solution(handles,K,M)

[eigV,Lam]  = eig(K,M);
Lam         = sqrt(diag(Lam));
[Lam , idx] = sort(Lam);
eigV        = eigV(:,idx);

%use Method 2 to mass normalize, per Dr Matt Allen script, class web site.
eigV = eigV*diag(diag(eigV'*M*eigV).^(-0.5));
eigV(abs(eigV)<2*eps('double'))=0;


%-------------------------------
function reset_axes(handles)

  
  L=1;
  W=2*L;
  springcoord( [ 0 -L ] , [ W -L ], 10, 8, .2);
  springcoord( [ W -L ] , [ 2*W -L ], 10, 8, .2);
  set(handles.figure1, 'CurrentAxes',handles.axes1);  
  cla;
  line([-0.2 2*W+0.2],[0 0]);
  drawnow;
 
  
%-------------------------------------------
function [h1,h2,h3,h4,h5]=make_one_plot(theta1,theta2,theta3,L,W,axis_type,i,max_time)

    h1    = line([0 L*sin(theta1) ],[0 -L*cos(theta1) ],'LineWidth',4,'Color',[1 0 0]);    
    h2    = line([W L*sin(theta2)+W],[0 -L*cos(theta2)],'LineWidth',4,'Color',[1 0 0]);    
    [ xvec, yvec ] = springcoord( [ L*sin(theta1)  -L*cos(theta1) ] , [ L*sin(theta2)+W -L*cos(theta2) ]);
    h3 = line(xvec,yvec);
    h4    = line([2*W L*sin(theta3)+2*W],[0 -L*cos(theta3)],'LineWidth',4,'Color',[1 0 0]);    
    [ xvec, yvec ] = springcoord( [ L*sin(theta2)+W  -L*cos(theta2) ] , [ L*sin(theta3)+2*W -L*cos(theta3) ]);
    h5 = line(xvec,yvec);
    if strcmp(axis_type,'normal')
        axis normal;
    elseif strcmp(axis_type,'equal')
        axis equal;
    elseif strcmp(axis_type,'square')
        axis square;
    else
        axis auto;
    end;
        
    xlim([-W,3*W+0.1]); ylim([-1.5*L,1.5*L]);
    xlabel( makeLabel(i,max_time),'interpreter','latex','FontSize',12);
        
    hold on;
    plot([0 W 2*W], [0 0 0], 'o');

%------------------------------------------------------
function title_ = make_title(Lam,eigV)

title_={ sprintf('mode \\hspace{5 mm} %d \\hspace{15 mm} %d \\hspace{11 mm} %d',1,2,3);
    sprintf('$\\theta_1 \\hspace{5 mm} %+3.3f \\hspace{5 mm} %+3.3f \\hspace{5 mm} %+3.3f$',eigV(1,1),eigV(1,2),eigV(1,3));
    sprintf('$\\theta_2 \\hspace{5 mm} %+3.3f \\hspace{5 mm} %+3.3f \\hspace{5 mm} %+3.3f$',eigV(2,1),eigV(2,2),eigV(2,3));
    sprintf('$\\theta_3 \\hspace{5 mm} %+3.3f \\hspace{5 mm} %+3.3f  \\hspace{5 mm} %+3.3f$',eigV(3,1),eigV(3,2),eigV(3,3));
    sprintf('$f(hz) \\hspace{4 mm}  %3.3f \\hspace{9 mm} %3.3f \\hspace{9 mm} %3.3f$',Lam(1)/(2*pi),Lam(2)/(2*pi),Lam(3)/(2*pi));
    sprintf('$\\omega \\hspace{10 mm} %3.3f \\hspace{9 mm} %3.3f \\hspace{9 mm} %3.3f$',Lam(1),Lam(2),Lam(3));
    ''};


%------------------------------------------------------
function xlabel_=makeLabel(t,maxTime)
xlabel_=[sprintf('time = $%3.2f$ sec',t) '      ' sprintf('max= $%3.2f$ sec',maxTime)];

% --- Executes on button press in stop_btn.
function stop_btn_Callback(hObject, eventdata, handles)
% hObject    handle to stop_btn (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

data = get(handles.figure1, 'UserData');
data.state = 'stop';
set(handles.figure1, 'UserData',data);


% --- Executes on button press in mode1_btn.
function mode1_btn_Callback(hObject, eventdata, handles)
% hObject    handle to mode1_btn (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of mode1_btn

data = get(handles.figure1, 'UserData');
data.mode1 = get(hObject,'Value');
data.state = 'stop';
set(handles.figure1, 'UserData',data);


% --- Executes on button press in mode2_btn.
function mode2_btn_Callback(hObject, eventdata, handles)
% hObject    handle to mode2_btn (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of mode2_btn

data = get(handles.figure1, 'UserData');
data.mode2 = get(hObject,'Value');
data.state = 'stop';
set(handles.figure1, 'UserData',data);

% --- Executes on button press in mode3_btn.
function mode3_btn_Callback(hObject, eventdata, handles)
% hObject    handle to mode3_btn (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of mode3_btn

data = get(handles.figure1, 'UserData');
data.mode3 = get(hObject,'Value');
data.state = 'stop';
set(handles.figure1, 'UserData',data);

% --- Executes on slider movement.
function k1_slider_Callback(hObject, eventdata, handles)
% hObject    handle to k1_slider (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'Value') returns position of slider
%        get(hObject,'Min') and get(hObject,'Max') to determine range of slider

data = get(handles.figure1, 'UserData');
data.k1 = get(hObject,'Value');
g=9.8;
data.K = [data.k1+0.5*data.m1*g -data.k1 0;-data.k1 data.k1+data.k2+0.5*data.m2*g -data.k2;0 -data.k2 data.k2+0.5*data.m3*g];
set(handles.k1_value,'String',num2str(data.k1));
data.state = 'stop';

reset_axes(handles);
[eigV,Lam]= obtain_solution(handles,data.K,data.M);
set(handles.figure1, 'CurrentAxes',handles.axes1);
title(make_title(Lam,eigV),'interpreter','latex','FontSize',12);
make_one_plot(data.theta1,data.theta2,data.theta3,1,2,data.axis_type,0,data.max_time);

set(handles.figure1, 'UserData',data);


% --- Executes during object creation, after setting all properties.
function k1_slider_CreateFcn(hObject, eventdata, handles)
% hObject    handle to k1_slider (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: slider controls usually have a light gray background.
if isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor',[.9 .9 .9]);
end


% --- Executes on slider movement.
function k2_slider_Callback(hObject, eventdata, handles)
% hObject    handle to k2_slider (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'Value') returns position of slider
%        get(hObject,'Min') and get(hObject,'Max') to determine range of slider

data = get(handles.figure1, 'UserData');
data.k2 = get(hObject,'Value');
g=9.8;
data.K = [data.k1+0.5*data.m1*g -data.k1 0;-data.k1 data.k1+data.k2+0.5*data.m2*g -data.k2;0 -data.k2 data.k2+0.5*data.m3*g];

set(handles.k2_value,'String',num2str(data.k2));
data.state = 'stop';

reset_axes(handles);
[eigV,Lam]= obtain_solution(handles,data.K,data.M);
set(handles.figure1, 'CurrentAxes',handles.axes1);
title(make_title(Lam,eigV),'interpreter','latex','FontSize',12);
make_one_plot(data.theta1,data.theta2,data.theta3,1,2,data.axis_type,0,data.max_time);

set(handles.figure1, 'UserData',data);

% --- Executes during object creation, after setting all properties.
function k2_slider_CreateFcn(hObject, eventdata, handles)
% hObject    handle to k2_slider (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: slider controls usually have a light gray background.
if isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor',[.9 .9 .9]);
end


% --- Executes on slider movement.
function m1_slider_Callback(hObject, eventdata, handles)
% hObject    handle to m1_slider (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'Value') returns position of slider
%        get(hObject,'Min') and get(hObject,'Max') to determine range of slider

data = get(handles.figure1, 'UserData');
data.m1 = get(hObject,'Value');
data.M = [data.m1 0 0;0 data.m2 0;0 0 data.m3];
set(handles.m1_value,'String',num2str(data.m1));
data.state = 'stop';

reset_axes(handles);
[eigV,Lam]= obtain_solution(handles,data.K,data.M);
set(handles.figure1, 'CurrentAxes',handles.axes1);
title(make_title(Lam,eigV),'interpreter','latex','FontSize',12);
make_one_plot(data.theta1,data.theta2,data.theta3,1,2,data.axis_type,0,data.max_time);

set(handles.figure1, 'UserData',data);


% --- Executes during object creation, after setting all properties.
function m1_slider_CreateFcn(hObject, eventdata, handles)
% hObject    handle to m1_slider (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: slider controls usually have a light gray background.
if isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor',[.9 .9 .9]);
end


% --- Executes on slider movement.
function m2_slider_Callback(hObject, eventdata, handles)
% hObject    handle to m2_slider (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'Value') returns position of slider
%        get(hObject,'Min') and get(hObject,'Max') to determine range of slider

data = get(handles.figure1, 'UserData');
data.m2 = get(hObject,'Value');
data.M = [data.m1 0 0;0 data.m2 0;0 0 data.m3];
set(handles.m2_value,'String',num2str(data.m2));
data.state = 'stop';

reset_axes(handles);
[eigV,Lam]= obtain_solution(handles,data.K,data.M);
set(handles.figure1, 'CurrentAxes',handles.axes1);
title(make_title(Lam,eigV),'interpreter','latex','FontSize',12);
make_one_plot(data.theta1,data.theta2,data.theta3,1,2,data.axis_type,0,data.max_time);

set(handles.figure1, 'UserData',data);


% --- Executes during object creation, after setting all properties.
function m2_slider_CreateFcn(hObject, eventdata, handles)
% hObject    handle to m2_slider (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: slider controls usually have a light gray background.
if isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor',[.9 .9 .9]);
end


% --- Executes on slider movement.
function m3_slider_Callback(hObject, eventdata, handles)
% hObject    handle to m3_slider (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'Value') returns position of slider
%        get(hObject,'Min') and get(hObject,'Max') to determine range of slider

data = get(handles.figure1, 'UserData');
data.m3 = get(hObject,'Value');
data.M = [data.m1 0 0;0 data.m2 0;0 0 data.m3];
set(handles.m3_value,'String',num2str(data.m3));
data.state = 'stop';

reset_axes(handles);
[eigV,Lam]= obtain_solution(handles,data.K,data.M);
set(handles.figure1, 'CurrentAxes',handles.axes1);
title(make_title(Lam,eigV),'interpreter','latex','FontSize',12);
make_one_plot(data.theta1,data.theta2,data.theta3,1,2,data.axis_type,0,data.max_time);

set(handles.figure1, 'UserData',data);


% --- Executes during object creation, after setting all properties.
function m3_slider_CreateFcn(hObject, eventdata, handles)
% hObject    handle to m3_slider (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: slider controls usually have a light gray background.
if isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor',[.9 .9 .9]);
end

%--------------------------------------------------------
function [ xvec, yvec ] = springcoord( pt1, pt2, varargin)
% SPRINGCOORD   Returns the coordinates for a spring starting at pt1 and
%   ends at pt2. Maximum length 'rmax', number of coils 'n', and offset of
%   the spring from the two ends 'd' are used to size the spring display
%   automatically.
%
%  Usage:
%  MUST first initialize the spring
%     [ xvec, yvec ] = springcoord( [ x1 y1 ] , [ x2 y2 ], n, rmax, d)
%  Stretch and compress the spring with new coordinates
%     [ xvec, yvec ] = springcoord( [ x1new y1new ] , [ x2new y2new ])
%
%  Diagram:
%      |<-- d -->|<----- n*h ------>|<-- d -->|
%      ___________/\  /\  /\  /\  /\___________
%   (x1,y1)         \/  \/  \/  \/          (x2,y2)
%
%   *h is the 2D longitudinal length of a single coil at the current
%    configration.
%
%  Tips: This function sizes the spring such that the spring becomes a
%       a single line at the maximum stretch length. You can make rmax
%       slightly larger than the actual maximum length to retain the shape.
%       To plot the spring, simply use plot(xvec,yvec).
%
%  Version 0.1a
%  Created by Dan Peng, 9/6/2010

% Initialize variables
persistent c d n
% Debug note: persistant variables are cleared whenever the .m file
%             is edited.

if nargin > 2
    n = varargin{1}; rmax = varargin{2};  d = varargin{3};
    smax = rmax - 2*d;       % Maximum length of the spring portion
    hmax = smax/n;           % Maximum 2D longitudinal length
    c = hmax/6;              % 2D length of the quarter coil.
else
    if isempty(c)
        disp('Please first initialized the spring');
        xvec = NaN; yvec = NaN;
        return
    end
end

s = norm(pt2-pt1) - 2*d; % Current length of the spring portion
h = s/n;                 % Current 2D longitudional length of single coil

% Calculate the spring coordinates along an unrotated x axis

pp = 0:(2*n-1);                       % Switches yoffset between +/-1
ypts = [ 0 0 (-ones(1,2*n)).^pp 0 0];
yscaler = sqrt(c^2-(h/4)^2);          % "Pitch" height
ypts = yscaler*ypts;

xpts = linspace(0,s,length(ypts)-2);
xpts = [ 0 d+xpts 2*d+xpts(end) ];    % Accounting for offsets

% Rotation matrix: R = [ e1 ; e2 ]
%                    = [ cos(th) -sin(th);
%                        sin(th)  cos(th ]
%
% Example on obtaining unit vector e1:
%   r = (pt2 - pt1)
%     = [ x2 ; y2 ] - [ x1 ; y1 ]
%     = [ x ; y ]
%
%   Then [ x ; y ]/norm(r) is effectively
%   [ adj/hyp ; opp/hyp ] or [ cos(th) ; sin(th) ]

e1 = (pt2 - pt1)'/norm(pt2-pt1); % Rotated unit vector e1
e2 = [ -e1(2); e1(1) ];          % Rotated unit vector e2

% Multiply the unrotated points by the rotation matrix.
xvec = pt1(1) + e1(1)*xpts + e2(1)*ypts;
yvec = pt1(2) + e1(2)*xpts + e2(2)*ypts;


% --- Executes on slider movement.
function max_sim_time_slider_Callback(hObject, eventdata, handles)
% hObject    handle to max_sim_time_slider (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'Value') returns position of slider
%        get(hObject,'Min') and get(hObject,'Max') to determine range of slider

data = get(handles.figure1, 'UserData');
data.max_time = get(hObject,'Value');
set(handles.max_sim_time_text,'String',num2str(data.max_time));

set(handles.figure1, 'UserData',data);


% --- Executes during object creation, after setting all properties.
function max_sim_time_slider_CreateFcn(hObject, eventdata, handles)
% hObject    handle to max_sim_time_slider (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: slider controls usually have a light gray background.
if isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor',[.9 .9 .9]);
end


% --- Executes on slider movement.
function delT_Callback(hObject, eventdata, handles)
% hObject    handle to delT (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'Value') returns position of slider
%        get(hObject,'Min') and get(hObject,'Max') to determine range of slider

data = get(handles.figure1, 'UserData');
data.delT = get(hObject,'Value');
set(handles.figure1, 'UserData',data);

% --- Executes during object creation, after setting all properties.
function delT_CreateFcn(hObject, eventdata, handles)
% hObject    handle to delT (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: slider controls usually have a light gray background.
if isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor',[.9 .9 .9]);
end


% --- Executes on button press in set_m1_to_one.
function set_m1_to_one_Callback(hObject, eventdata, handles)
% hObject    handle to set_m1_to_one (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


data = get(handles.figure1, 'UserData');
data.m1 = 1;
data.M = [data.m1 0 0;0 data.m2 0;0 0 data.m3];
set(handles.m1_value,'String',num2str(data.m1));
set(handles.m1_slider,'Value',1);
data.state = 'stop';

reset_axes(handles);
[eigV,Lam]= obtain_solution(handles,data.K,data.M);
set(handles.figure1, 'CurrentAxes',handles.axes1);
title(make_title(Lam,eigV),'interpreter','latex','FontSize',12);
make_one_plot(data.theta1,data.theta2,data.theta3,1,2,data.axis_type,0,data.max_time);

set(handles.figure1, 'UserData',data);


% --- Executes on button press in set_m2_to_one.
function set_m2_to_one_Callback(hObject, eventdata, handles)
% hObject    handle to set_m2_to_one (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

data = get(handles.figure1, 'UserData');
data.m2 = 1;
data.M = [data.m1 0 0;0 data.m2 0;0 0 data.m3];
set(handles.m2_value,'String',num2str(data.m2));
set(handles.m2_slider,'Value',1);
data.state = 'stop';

reset_axes(handles);
[eigV,Lam]= obtain_solution(handles,data.K,data.M);
set(handles.figure1, 'CurrentAxes',handles.axes1);
title(make_title(Lam,eigV),'interpreter','latex','FontSize',12);
make_one_plot(data.theta1,data.theta2,data.theta3,1,2,data.axis_type,0,data.max_time);

set(handles.figure1, 'UserData',data);


% --- Executes on button press in set_m3_to_one.
function set_m3_to_one_Callback(hObject, eventdata, handles)
% hObject    handle to set_m3_to_one (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

data = get(handles.figure1, 'UserData');
data.m3 = 1;
data.M = [data.m1 0 0;0 data.m2 0;0 0 data.m3];
set(handles.m3_value,'String',num2str(data.m3));
set(handles.m3_slider,'Value',1);
data.state = 'stop';

reset_axes(handles);
[eigV,Lam]= obtain_solution(handles,data.K,data.M);
set(handles.figure1, 'CurrentAxes',handles.axes1);
title(make_title(Lam,eigV),'interpreter','latex','FontSize',12);
make_one_plot(data.theta1,data.theta2,data.theta3,1,2,data.axis_type,0,data.max_time);
set(handles.figure1, 'UserData',data);


% --- Executes on button press in set_k2_to_one.
function set_k2_to_one_Callback(hObject, eventdata, handles)
% hObject    handle to set_k2_to_one (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

data = get(handles.figure1, 'UserData');
data.k2 = 1;
g=9.8;
data.K = [data.k1+0.5*data.m1*g -data.k1 0;-data.k1 data.k1+data.k2+0.5*data.m2*g -data.k2;0 -data.k2 data.k2+0.5*data.m3*g];

set(handles.k2_value,'String',num2str(data.k2));
set(handles.k2_slider,'Value',1);
data.state = 'stop';

reset_axes(handles);
[eigV,Lam]= obtain_solution(handles,data.K,data.M);
set(handles.figure1, 'CurrentAxes',handles.axes1);
title(make_title(Lam,eigV),'interpreter','latex','FontSize',12);
make_one_plot(data.theta1,data.theta2,data.theta3,1,2,data.axis_type,0,data.max_time);

set(handles.figure1, 'UserData',data);


% --- Executes on button press in set_k1_to_one.
function set_k1_to_one_Callback(hObject, eventdata, handles)
% hObject    handle to set_k1_to_one (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

data = get(handles.figure1, 'UserData');
data.k1 = 1;
g=9.8;
data.K = [data.k1+0.5*data.m1*g -data.k1 0;-data.k1 data.k1+data.k2+0.5*data.m2*g -data.k2;0 -data.k2 data.k2+0.5*data.m3*g];

set(handles.k1_value,'String',num2str(data.k1));
set(handles.k1_slider,'Value',1);
data.state = 'stop';


reset_axes(handles);
[eigV,Lam]= obtain_solution(handles,data.K,data.M);
set(handles.figure1, 'CurrentAxes',handles.axes1);
title(make_title(Lam,eigV),'interpreter','latex','FontSize',12);
make_one_plot(data.theta1,data.theta2,data.theta3,1,2,data.axis_type,0,data.max_time);

set(handles.figure1, 'UserData',data);


% --- Executes on selection change in axis_selection.
function axis_selection_Callback(hObject, eventdata, handles)
% hObject    handle to axis_selection (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = cellstr(get(hObject,'String')) returns axis_selection contents as cell array
%        contents{get(hObject,'Value')} returns selected item from axis_selection

contents = cellstr(get(hObject,'String'));
data = get(handles.figure1, 'UserData');
data.axis_type = contents{get(hObject,'Value')};
set(handles.figure1, 'UserData',data);

% --- Executes during object creation, after setting all properties.
function axis_selection_CreateFcn(hObject, eventdata, handles)
% hObject    handle to axis_selection (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

% --- Executes on slider movement.
function theta1_x0_tag_Callback(hObject, eventdata, handles)
% hObject    handle to theta1_x0_tag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'Value') returns position of slider
%        get(hObject,'Min') and get(hObject,'Max') to determine range of slider

data = get(handles.figure1, 'UserData');
data.theta1 = get(hObject,'Value');
set(handles.initial_x1_text,'String',num2str(data.theta1));
data.theta1 = data.theta1*pi/180;
data.state = 'stop';
reset_axes(handles)
make_one_plot(data.theta1,data.theta2,data.theta3,1,2,data.axis_type,0,data.max_time);

set(handles.figure1, 'UserData',data);


% --- Executes during object creation, after setting all properties.
function theta1_x0_tag_CreateFcn(hObject, eventdata, handles)
% hObject    handle to theta1_x0_tag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: slider controls usually have a light gray background.
if isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor',[.9 .9 .9]);
end


% --- Executes on slider movement.
function theta2_x0_tag_Callback(hObject, eventdata, handles)
% hObject    handle to theta2_x0_tag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'Value') returns position of slider
%        get(hObject,'Min') and get(hObject,'Max') to determine range of slider

data = get(handles.figure1, 'UserData');
data.theta2 = get(hObject,'Value');
set(handles.initial_x2_text,'String',num2str(data.theta2));
data.theta2 = data.theta2*pi/180;
data.state = 'stop';
reset_axes(handles)
make_one_plot(data.theta1,data.theta2,data.theta3,1,2,data.axis_type,0,data.max_time);

set(handles.figure1, 'UserData',data);


% --- Executes during object creation, after setting all properties.
function theta2_x0_tag_CreateFcn(hObject, eventdata, handles)
% hObject    handle to theta2_x0_tag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: slider controls usually have a light gray background.
if isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor',[.9 .9 .9]);
end


% --- Executes on button press in initial_x1_zero_button.
function initial_x1_zero_button_Callback(hObject, eventdata, handles)
% hObject    handle to initial_x1_zero_button (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


data = get(handles.figure1, 'UserData');
data.theta1 = 0;
set(handles.initial_x1_text,'String','0');
set(handles.theta1_x0_tag,'Value',0);
data.state = 'stop';
reset_axes(handles)
make_one_plot(data.theta1,data.theta2,data.theta3,1,2,data.axis_type,0,data.max_time);

set(handles.figure1, 'UserData',data);

% --- Executes on button press in initial_x2_zero_button.
function initial_x2_zero_button_Callback(hObject, eventdata, handles)
% hObject    handle to initial_x2_zero_button (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

data = get(handles.figure1, 'UserData');
data.theta2 = 0;
set(handles.initial_x2_text,'String','0');
set(handles.theta2_x0_tag,'Value',0);
data.state = 'stop';
reset_axes(handles)
make_one_plot(data.theta1,data.theta2,data.theta3,1,2,data.axis_type,0,data.max_time);

set(handles.figure1, 'UserData',data);



% --- Executes on slider movement.
function theta3_x0_tag_Callback(hObject, eventdata, handles)
% hObject    handle to theta3_x0_tag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'Value') returns position of slider
%        get(hObject,'Min') and get(hObject,'Max') to determine range of slider

data = get(handles.figure1, 'UserData');
data.theta3 = get(hObject,'Value');
set(handles.initial_x3_text,'String',num2str(data.theta3));
data.theta3 = data.theta3*pi/180;
data.state = 'stop';

reset_axes(handles)
make_one_plot(data.theta1,data.theta2,data.theta3,1,2,data.axis_type,0,data.max_time);

  
set(handles.figure1, 'UserData',data);



% --- Executes during object creation, after setting all properties.
function theta3_x0_tag_CreateFcn(hObject, eventdata, handles)
% hObject    handle to theta3_x0_tag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: slider controls usually have a light gray background.
if isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor',[.9 .9 .9]);
end


% --- Executes on button press in initial_x3_zero_button.
function initial_x3_zero_button_Callback(hObject, eventdata, handles)
% hObject    handle to initial_x3_zero_button (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

data = get(handles.figure1, 'UserData');
data.theta3 = 0;
set(handles.initial_x3_text,'String','0');
set(handles.theta3_x0_tag,'Value',0);

reset_axes(handles)
make_one_plot(data.theta1,data.theta2,data.theta3,1,2,data.axis_type,0,data.max_time);
  
data.state = 'stop';
set(handles.figure1, 'UserData',data);


% --- Executes on button press in reset_btn.
function reset_btn_Callback(hObject, eventdata, handles)
% hObject    handle to reset_btn (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

data = get(handles.figure1, 'UserData');
reset_axes(handles)
make_one_plot(data.theta1,data.theta2,data.theta3,1,2,data.axis_type,0,data.max_time);
  
data.state = 'stop';
set(handles.figure1, 'UserData',data);
