function status = nma_ISSPD( A )
% checks that matrix is SPD 

%
% INPUT:
%   A: 2D matrix
% OUTPUT:
%   status: true if spd, false if not
%
% EXAMPLE:
%   A=[.5 0;0 1];
%   nma_is_spd_matrix(A)
%      1
%
%   A=[-.5 0;0 1];
%   nma_is_spd_matrix(A)
%      0
%
% copyright: Nasser M. Abbasi
% updated 10/26/2010

if nma_ISSYM(A)
   e = eig(A);
   status = all(e>0);
else
   status = false;
end

end

