function v=nma_inputNumeric(NUMERIC_TYPE,prompt,lowerLimit,upperLimit)
% read a numeric number from user and keeps trying untill the user types correct value

% INPUT:
%  NUMERIC_TYPE: an integer to tell me the datatype the user expects as
%                input. use 0 for an integer input. use 1 for a float
%                input. No other types are supported.
% prompt: a string which is the prompt to display.
% lowerlimit: the value which the input can not be less than.
% upperlimit: the value which the input can not be more than.
%
% Nasser Abbasi. MAE 185
%
TRUE=1;
FALSE=0;
INTEGER=0;

validInput=FALSE;

while(~validInput)    
    v = input(prompt);
    if(isnumeric(v))
        if( v < lowerLimit |  v > upperLimit)
            if(v<=lowerLimit)
                fprintf('value can not lower than %f. Please try again.\n',lowerLimit);
            else
                fprintf('value can not be greater than %f. Please try again.\n',upperLimit);
            end
        else       
            if(NUMERIC_TYPE==INTEGER & round(v)~=v)
                fprintf('value must be an integer value. PLease try again\n');
            else
                validInput=TRUE;
            end
        end
    else
        fprintf('value must be a numeric value. PLease try again\n');
    end
end
