function nma_generate_dep_files_V2()
%This function generates one text file for each m file it finds
%in the same folder it is running from. For each m file it
%finds, it generates the text file which contains a list of
%the m files that the current m file depends on.
%
%This uses fdep() function from matlab central
%
%by Nasser M. Abbasi
%march 1, 2013  clean up more, moved to htlatex
%Nov 22, 2012
%

filesInformation=struct(...
    'name',{'nma_math228.m',...
            'nma_HW2_math_228B_problem3.m',...
            'nma_poisson_GUI.m',...
            'nma_math_228b_HW4_parblem_1_part_b.m',...
            'nma_eme_121_lab1.m',...
            'nma_advection_pde_1D.m',...
            'nma_lab3_eme_121.m',...
            'nma_diffusion_1d.m',...
            'nma_lab2_eme_121.m',...
            'nma_orbit_simulator.m',...
            'nma_MAE121_spring_2010_lab4.m',...
            'nma_steady_state.m'},...
    'images',{{'nma_math_228_main_GUI.png'},...
             {'nma_HW2_math_228B_problem3_ANIMATION_600_seconds_problem_3_part_c.gif','nma_HW2_math_228B_problem3_ANIMATION_300_seconds_problem_3_part_b.gif'},...
             {'nma_poisson_GUI_animation.gif','nma_poisson_main_screen_shot.png','nma_poisson_screen_shot.png'},...
             {'problem_1_triangle_bounce_off_both_walls.gif','problem1_part_b_2_sin_bounce_off_LEFT_wall.gif'},...
             {'nma_eme_121_lab1_animation.gif','nma_eme_121_lab1_screen_shot.png'},...
             {'nma_advection_pde_1D_animated.gif'},...
             {'nma_mae121_spring_2010_lab3_demo.gif'},...
             {'nma_1D_diffusion_final_jan_12_2011.png'},...
             {'../../my_courses/UC_davis/spring_2011/MAE_121_eng_dynamics/lab/lab_2/nma_MAE121_spring_2010_lab2_animation.gif'},...
             {'orbit.gif'},...
             {'../../my_courses/UC_davis/spring_2011/MAE_121_eng_dynamics/lab/lab_4/nma_MAE121_spring_2010_lab4_animation.gif'},...
             {'nma_steady_state_screen_shot.png'}});
         
specialFileNames={filesInformation.name};
specialFileImages={filesInformation.images};

filesWithReports={{'nma_HW2_math_228B_problem3.m','../../my_courses/UC_davis/winter_2011/math_228b/HWs/HW2/index.htm'},...    
            {'nma_poisson_GUI.m','../../my_courses/UC_davis/fall_2010/math_228a/HWs/HW3/index.htm'},...
            {'nma_math_228b_HW4_parblem_1_part_b.m','../../my_courses/UC_davis/winter_2011/math_228b/HWs/HW4/index.htm'},...
            {'nma_eme_121_lab1.m','../../my_courses/UC_davis/spring_2011/MAE_121_eng_dynamics/lab/lab_one/index.htm'},...
            {'nma_advection_pde_1D.m','../../my_courses/UC_davis/winter_2011/math_228b/HWs/HW3/index.htm'},...
            {'nma_lab3_eme_121.m','../../my_courses/UC_davis/spring_2011/MAE_121_eng_dynamics/lab/lab_3/index.htm'},...
            {'nma_lab2_eme_121.m','../../my_courses/UC_davis/spring_2011/MAE_121_eng_dynamics/lab/lab_2/index.htm'},...
            {'nma_MAE121_spring_2010_lab4.m','../../my_courses/UC_davis/spring_2011/MAE_121_eng_dynamics/lab/lab_4/index.htm'}};
                                                
    
list_  = dir('*.m');
path_  = genpath('../EXTERNAL');
addpath(path_);

if isempty(list_)
    fprintf('no matlab files found\n');
    return
end

[html_fid,message] = fopen('../index.tex','w+t');
if html_fid==-1
    error('error opening %s, message is %s\n','../table.tex',message);
end

fprintf(html_fid,['\\documentclass[12pt]{article} \n',...
                  '\\usepackage{ifpdf} \n',...
                  '\\usepackage{hyperref} \n',...
                  '\\makeatletter \n',...
                  '\\edef\\texforht{TT\\noexpand\\fi \n',...
                  '\\@ifpackageloaded{tex4ht} \n',...
                  '{\\noexpand\\iftrue} \n',...
                  '{\\noexpand\\iffalse}} \n',...
                  '\\makeatother \n',...
                  '\\usepackage{geometry} \n',...
                  '\\usepackage[T1]{fontenc} \n',...
                  '\\usepackage{tabularx} \n',...
                  '\\usepackage{amsmath} \n',...
                  '\\usepackage{amsfonts} \n',...
                  '\\usepackage{amssymb} \n',...
                  '\\usepackage{graphicx} \n',...
                  '\\usepackage{multicol} \n',...
                  '\\usepackage{array} \n',...
                  '\\usepackage{booktabs} \n',...
                  '\\usepackage{color} \n',...
                  '\\pagecolor{white} \n',...
                  '\\newcounter{c} \n',...
                  '\\begin{document} \n\n',...
                  '\\title{some of my matlab functions, GUI apps and Matlab scripts} \n',...
                  '\\author{Nasser M. Abbasi} \n',...
                  '\\date{\\today} \n',...
                  '\\maketitle \n'....
                  '\\if\\texforht \\href{../../index.htm}{HOME} \\fi \n\n',...                                  
                  'zip files are build such that each is self contained with all the',...
                  'needed matlab files and .fig file (if applicable) to run each application',...
                  'or function from the directory created once the zip file is unziped.\n\n',...
                  'Work in progree, this page is updated all the time.\n\n']);

%number, name/zip files, depend, description, note 

fprintf(html_fid,['\\begin{tabular}{|p{.4in}|p{2.8in}|p{.4in}|p{.4in}|p{4in}| } \n',...
                  '\\hline \n',...
                  '\\# & file name & depend & zip &description \\\\ \n']);
    

    fprintf(html_fid,'%%-----------------------------------------------------------------------\n');    
    fprintf(html_fid,'%d\n',1);

    %function name column
    fprintf(html_fid,...
        '&\\href{../EE518_CT_project/index.htm}{{\\small COMPUTED TOMOGRAPHY, MATHEMATICS AND SIMULATION using Matlab}} \n');  
                 
    %depend column
    fprintf(html_fid,'&\n');        
    
    %zip file column
    fprintf(html_fid,'&\n');            
    %description column    
    fprintf(html_fid,['& ' ,...
      '\\if\\texforht  \\HCode{<img src="../EE518_CT_project/nma_EE518_CT_animation.gif" width="200" height="200">}  \\fi',...
      '\\if\\texforht  \\HCode{<img src="animation_backprojection.gif" width="200" height="200">} \\fi']);                             
    fprintf(html_fid,'\\\\ \n');  

    fprintf(html_fid,'%%-----------------------------------------------------------------------\n');    
    fprintf(html_fid,'%d\n',2);

    %function name column
    fprintf(html_fid,['& ',...
      '\\href{../Matlab_implementation_of_LinearSolver/nma_code.htm}{{\\small implementation of LU Decomposition and Linear Solver using Matlab}} \n']);
                       
    %depend column
    fprintf(html_fid,'&\n');        
    
    %zip file column
    fprintf(html_fid,'&\n');            
    %description column    
    fprintf(html_fid,'&\n');                     
    fprintf(html_fid,'\\\\ \n');  
    
    fprintf(html_fid,'%%-----------------------------------------------------------------------\n');    
    fprintf(html_fid,'%d\n',3);

    %function name column
    fprintf(html_fid,['&{\\small Small Matlab GUI untility to change units of a Matlab .fig file. Make sure to save a copy of your fig file before using, just in case.}',...
      '\\href{../my_matlab_functions/change_figure_units/index.htm}{{\\small HTML}} \n']);
                 
    %depend column
    fprintf(html_fid,'&\n');        
    
    %zip file column
    fprintf(html_fid,'&\n');            
    %description column    
    fprintf(html_fid,'&\n');                     
    fprintf(html_fid,'\\\\ \n');      
    
    ii=4;
for i=1:length(list_)
    fprintf('processing %s\n',list_(i).name)
    
    %create a txt file to write the dependecy into
    [fid_,name_of_matlab_function] = open_file(list_(i).name);
    
    %write the dependency into the file
    files_to_zip = write_dependency(fid_,list_(i).name);
    fileDescription = help(list_(i).name);   

    fclose(fid_);
    
    %     %make a zip file of the m file and any of its dependency
    %     find if there is a fig file associated with this m file since
    %     dep() does not find it. If so, add it explicitly
    p = dir([name_of_matlab_function '.fig']);
    if length(p)==1
        files_to_zip =[p(1).name;files_to_zip];
    end
    
    if strcmpi(name_of_matlab_function,'nma_poisson_GUI')
        files_to_zip =['nma_poisson_grid.png ';
            'nma_poisson_step_black.png';
            'nma_poisson_play_black.png';
            'nma_poisson_stop_black.png';
            'nma_poisson_reset.jpg'
            files_to_zip];
    end
    
    zipFileName = [name_of_matlab_function '.zip'];
    zip(['../depend/'  zipFileName],files_to_zip);
        

    fprintf(html_fid,'%%-----------------------------------------------------------------------\n');    
    fprintf(html_fid,'%d\n',ii);
    ii=ii+1;

    %function name column
    fprintf(html_fid,'& \n');    
    fprintf(html_fid,'\\href{depend/%s.m.txt}{{\\small %s.m}} \n',...
        name_of_matlab_function,...
        make_name_latex_ready(name_of_matlab_function));
    
    idx=cellfun(@(x) strcmp([name_of_matlab_function '.m'],x{1}),filesWithReports);
    if any(idx)                   
       fprintf(html_fid,'\\href{%s}{ report}\n',filesWithReports{idx}{2});       
    end    
                 
    %depend column 
    fprintf(html_fid,'& \\href{depend/%s_DEP.txt}{{\\small depend}} \n',...       
        name_of_matlab_function);      
    
    %zip file column
    fprintf(html_fid,'&  \n');    
    fprintf(html_fid,'\\href{depend/%s}{{\\small zip}}\n',...
                     zipFileName);       
        
        
    %description column
    fprintf(html_fid,'&{\\small %s}\n', make_name_latex_ready(fileDescription));
       
   
    idx=cellfun(@(x) strcmp([name_of_matlab_function '.m'],x),specialFileNames);
    if any(idx)
       imageFiles = specialFileImages{idx};
      
      
       for k= 1:length( imageFiles )
           thisImageFile=imageFiles{k};
           fprintf(html_fid,'\\if\\texforht \\HCode{<img src="%s" width="200" height="200">} \\fi\n',thisImageFile);                                
       end 
    end
    
    fprintf(html_fid,'\\\\ \n');  

end

fprintf(html_fid,'\\end{tabular}\n');
fprintf(html_fid,'\\end{document}\n');

fclose(html_fid);
rmpath(path_);

end

%---------------------------------------------
function fileDescription = obtainFileDescription(mFileName)

[fid,message] = fopen(mFileName,'r');
if fid==-1
    error('error opening %s, message is %s\n',mFileName,message);
end
fileDescription = fgetl(fid);
if length(fileDescription)>1
   fileDescription = fileDescription(2:end);
end
fclose(fid);

end
%------------------------------------------
function new_name = make_name_latex_ready(name)

   new_name = strrep(name, '_', '\_');

end
%-----------------------------------------------------------
function [fid,name_of_matlab_function]=open_file(name)

[pathstr, name_of_matlab_function, ext] = fileparts(name);
new_name = ['../depend/' name_of_matlab_function '_DEP.txt'];
[fid,message] = fopen(new_name,'w+t');
if fid==-1
    error('error opening %s, message is %s\n',new_name,message);
end
[status,message]=copyfile(name,['../depend/' name '.txt']);
if not(status )
    error('error copying %s, message is %s\n',name,message);
end
end
%-------------------------------------------------------------
function deps=write_dependency(fid,function_name)

fprintf(fid,'%s depends on: \n',function_name);
fprintf(fid,'---------------------------------------------\n');

p = fdep(function_name,'-q');

for j=1:p.nfun-1
    [pathstr, name_of_depends_file, ext] = fileparts(p.fun{j+1});
    fprintf(fid,'%s\n',[name_of_depends_file '.m']);
end
deps=p.fun;

end
