function nSteps=nma_findPointOnLine(stepSize,lineLength,target,tol)
%helper function for rocket design project

%function nSteps=nma_findPointOnLine(stepSize,lineLength,target,tol)
%
% Function to find how many steps needed to reach withing tolearance
% close to a point on a line by taking fixed number of steps. Line wrapes
% around.
%
%INPUT:
%   stepSize: the step size
%   lineLength: The line length
%   target: The distance from leftend of line that we want to reach
%   tol: tolerance in abs. value
%
%OUTPUT:
%   nSteps: number of steps needed
%
%Author Nasser Abbasi. May 22, 2003
%


currentDist=0;
nSteps=0;

while(1)
    currentDist=currentDist+stepSize;    
    nSteps=1;
    while(currentDist <= lineLength)
        if( abs (currentDist-target) < tol )
            return;
        end
        rem=lineLength-currentDist;
        if(rem < stepSize)
            currentDist=stepSize-rem;
        else
            currentDist=currentDist+stepSize;
        end
        nSteps=nSteps+1;                   
    end        
end
