function [v,status] = nma_evaluate_1D_function(str,data,var)
%evaluates string as 1D function for boundary conditions

% force_string_input= strtrim(str);
% 
% if strcmp(force_string_input, '0') || strcmp(force_string_input, '')
%    force_string = ['0 .*' var];
% else
%    force_string =force_string_input;
% end
% 
% force_string = ['@(' var ')' force_string];



force_string_input= strtrim(str);

if strcmp(force_string_input, '0') || strcmp(force_string_input, '')
   force_string_input = ['0 .*' var];
end

force_string_input = ['@(' var ')' force_string_input];

status = 1;
v=0;

try
   forceHandle = str2func(force_string_input);
   v=forceHandle(data);
   [n,~]=size(v(:));
   if n==1  % it is a consnt
      v = v * ones(size(data));
   end
catch ME
   status = 0;
   return;
end

end