classdef nma_refinement_study_manager < handle
%class used for doing refinement study for my math 228 numerical PDE class

%This class is used for doing refinement study for my
%math 228 numerical pde class. THis class has methods
%to accept information about each simulation run,
%and at the end it can print the error table.
%
% currently this only works with successive
% error method for refinement study. i.e. not
% with using exact solution. Need to add that later.
%
%Nasser M. Abbasi
%UC Davis, Math 228B


   
   
   properties(GetAccess = 'private', SetAccess = 'private')
      
      %headings_row = {'#','N', 'delt', 'h',   'e_2',  'ratio', 'e_1', 'ratio', 'e_m',  'ratio'};
      %format_row   = {'d','d','.6f',   '.6f', '.5f',  '.5f',   '.4f', '.5f',   '.4f',  '.5f'};
            
      headings_row = {'N', 'delt', 'h',   'e_2',  'ratio', 'e_1', 'ratio', 'e_m',  'ratio'};
      format_row   = {'d','.6f',   '.6f', '.5f',  '.5f',   '.4f', '.5f',   '.4f',  '.5f'};
      
      field_width    = 15;
      tbl;
      current_index  = 0;
      file_id        = 1;
      last_error     = 0;
      
      last_error_2   = 0;
      last_error_1   = 0;
      last_error_max = 0;
      
      last_u = 0;
      SKIP   = 0;
   end
   
   methods
      %CONSTRUCTOR
      function obj = nma_refinement_study_manager(nRows,SKIP)
         obj.tbl  = zeros(nRows,length(obj.headings_row));
         obj.SKIP = SKIP;
      end
          
      %-----------------------------------------------
      % this function uses exact solution to find error ratio
      % assuming SKIP exists (use for cell centered problems)
      function add_exact_with_skip_1D(obj, u, u_exact, h, delt)
         if obj.current_index == 0
            error_2       = 0;
            error_1       = 0;
            error_max     = 0;                        
            error_ratio_2 = 0;
            error_ratio_1 = 0;            
            error_ratio_max = 0;            
            
         else      
            
            last_grid_size = obj.tbl(obj.current_index,1); 
            current_solution_mapped_to_coarse = zeros(1,last_grid_size);
            i = 2:3:length(u);
            current_solution_mapped_to_coarse(1:last_grid_size) = u(i);
            
            error_2 = sqrt(obj.tbl(obj.current_index,3))*...
                   norm(obj.last_u - current_solution_mapped_to_coarse,2);            
                
            error_ratio_2 = obj.last_error_2 / error_2;     
                           
            
            error_1       = obj.tbl(obj.current_index,3)*...
               norm(obj.last_u - current_solution_mapped_to_coarse,1);                        
            error_ratio_1 = obj.last_error_1 / error_1;            

            
            error_max       = norm(obj.last_u - current_solution_mapped_to_coarse,inf);
            error_ratio_max = obj.last_error_max / error_max;  
         end
         obj.last_u         = u;
         obj.last_error_2   = error_2;
         obj.last_error_1   = error_1;
         obj.last_error_max = error_max;         
         obj.current_index = obj.current_index + 1;         

         %row=[obj.current_index, length(u), delt, h,...
         %   error_2, error_ratio_2, error_1, error_ratio_1, error_max, error_ratio_max];

         row=[length(u), delt, h,...
            error_2, error_ratio_2, error_1, error_ratio_1, error_max, error_ratio_max];
         
         obj.tbl(obj.current_index,:) = row;                  
      end
            
      %-----------------------------------------------
      % this function uses exact solution to find error ratio
      function add_exact(obj, u, u_exact, h, delt)
         if obj.current_index == 0
            error_2       = 0;
            error_1       = 0;
            error_max     = 0;                        
            error_ratio_2 = 0;
            error_ratio_1 = 0;            
            error_ratio_max = 0;            
            
         else            
            error_2       = sqrt(h)*norm(u - u_exact,2);                            
            error_ratio_2 = obj.last_error_2 / error_2;            
            
            error_1       = h*norm(u - u_exact,1);                            
            error_ratio_1 = obj.last_error_1 / error_1;            

            error_max       = norm(u - u_exact,inf);
            error_ratio_max = obj.last_error_max / error_max;  
         end
         
         obj.last_error_2   = error_2;
         obj.last_error_1   = error_1;
         obj.last_error_max = error_max;         
         obj.current_index = obj.current_index + 1;         

         %row=[obj.current_index, length(u), delt, h,...
         %   error_2, error_ratio_2, error_1, error_ratio_1, error_max, error_ratio_max];

         row=[length(u), delt, h,...
            error_2, error_ratio_2, error_1, error_ratio_1, error_max, error_ratio_max];
         
         obj.tbl(obj.current_index,:) = row;                  
      end
      
      %---------------------------------------------------
      %this function uses successive error to find ratio, 1D version
      function add_succ_1D(obj, u, h, delt)
         if obj.current_index == 0
            error = 0;
            error_ratio = 0;
         else
                       
            i = 1:2:length(u);            
            current_solution_mapped_to_coarse = u(i);            
            
            error = sqrt(obj.tbl(obj.current_index,3))*...
                   norm(obj.last_u - current_solution_mapped_to_coarse,2);            
                
            error_ratio = obj.last_error / error;             
         end
         
         obj.last_u        = u;
         obj.last_error    = error;
         obj.current_index = obj.current_index + 1;         

         
         row=[length(u), delt, h, error, error_ratio, 0,0, 0,0];
         
         obj.tbl(obj.current_index,:) = row;
      end
      
      %---------------------------------------------------
      %this function uses successive error to find ratio, 2D version
      function add(obj, u, h, delt)
         if obj.current_index == 0
            error = 0;
            error_ratio = 0;
         else
            last_grid_size = obj.tbl(obj.current_index,2);
            current_solution_mapped_to_coarse = zeros(last_grid_size);
            for i = 1:last_grid_size
                  ii = i*obj.SKIP-1;
                  for j = 1:last_grid_size
                     jj = j*obj.SKIP-1;
                     current_solution_mapped_to_coarse(i,j) = u(ii,jj);
                  end
            end
            
            error = obj.tbl(obj.current_index,4)*...
                   norm(obj.last_u - current_solution_mapped_to_coarse,2);            
                
            error_ratio = obj.last_error / error;            
         end
         
         obj.last_u     = u;
         obj.last_error = error;
         obj.current_index = obj.current_index + 1;         

         %row=[obj.current_index, size(u,1), delt, h,...
         %   error, error_ratio];

         row=[size(u,1), delt, h,...
            error, error_ratio];
         
         obj.tbl(obj.current_index,1:length(row)) = row;
      end
      
      %------------------------------------------
      % returns formatted error table
      function [hd,bdy] = format_table(obj)
         [hd,bdy] =  nma_format_matrix(obj.headings_row,...
            obj.tbl, obj.field_width, obj.format_row, obj.file_id,false);
      end
      
      %-----------------------------------------------
      % returns the error table
      function tbl  = get_table(obj)
         tbl = obj.tbl;
      end
   end
   
end

