function nma_LaxWendroff_test()
% driver tests nma_LaxWendroff class

 h       = 0.01;         %space grid size
 L       = 1;            %total length
 X       = 0:h:L;        %grid
 u0      = sin(2*pi*X);  % initial concentration
 a       = 1;            %speed of fluid
 courant = 0.8;           %courant number (CFL)
 delt    = courant*h/a;  %delta time, time space

 figure(1);          
 o = nma_LaxWendroff(delt,h,a,u0);

 currentTime = 0;
 nSteps      = 1/delt;
 
 for i=1:nSteps
     u = o.makeStep();     
     currentTime = currentTime+delt;
     plot(X,u);
     hold on;
     plot(X,u0,'r');    
     title(sprintf('time=%f',currentTime));
     hold off;
     drawnow();    
 end

end

