classdef nma_LaxWendroff  < handle
%Class implements Lax-Wendroff for 1D advection PDE

   % Class to implement the Lax-Wendroff scheme to solve
   % advection PDE in 1-D
   % see file nma_testLaxWendroff.m for an example how to use this class
   %
   % by Nasser M. Abbasi
   %
   
   properties(GetAccess = 'private', SetAccess = 'private')
      u=0;
      delt=0;
      h=0;
      a=0;
      N=0;
   end
   
   methods
      function obj = nma_LaxWendroff(delt,h,a,u0)
         obj.delt=delt;
         obj.h=h;
         obj.a=a;
         obj.u=[u0(end-1) u0 u0(2)];
         obj.N=length(u0);
      end
      %-------------
      function r = makeStep(obj)
         i          = 2:length(obj.u)-1;         
         A          = obj.a*obj.delt/obj.h;
         
         obj.u(i)   = obj.u(i)-(A/2)*(obj.u(i+1)-obj.u(i-1))+...
                      A^2/2*(obj.u(i-1)-2*obj.u(i)+obj.u(i+1));  
                 
         obj.u(1)   = obj.u(end-2);
         obj.u(end) = obj.u(3);
         
         r          = obj.u(2:end-1);
      end      
   end
   
end

