function A = nma_FDM_matrix_laplace_1D_robin(N,h,alpha)
% builds finite difference A matrix for 1-D laplace 

%-----------------------------------------------------------------
% A = nma_FDM_matrix_laplace_1D_robin(N,h)
%
% returns the A matrix, which is the system finite difference matrix for
% numerical solution of 1-D laplace equation Uxx = f, with nuemman
% boundary conditions on both sides of the element. Based on 3 point
%
% INPUT:  N, the number of nodes
%         h, spacing between nodes
%
% OUTPUT: A, the matrix , see below
%
% 
% A = A/h^2;  % h is space between points
% U = A\f;  % solve for U, where Uxx=f, need to set f as function before.
%
% copyright: Nasser M. Abbasi
% 10/18/2010

A = zeros(N);
for i=1:N
    for j=1:N
        % as before, part(a), Dirichlet  B.C.
        if(i==j)
            A(i,j) = -2;
        else
            if( i==j+1 || i==j-1 )
                A(i,j) = 1;
            end
        end
    end
end

%fix A above 
A(1,1) = -1-alpha*h;

end

