function A = nma_FDM_matrix_laplace_1D_dirichlet(N )
% builds finite difference A matrix for 1-D laplace dirichlet boundary conditions

%%
% nma_FDM_matrix_laplace_1D_dirichlet(N)
%
% returns the A matrix, which is the system finite difference matrix for
% numerical solution of 1-D laplace equation Uxx = f, with dirichlet
% boundary conditions on both sides of the element. Based on 3 point
% scheme    U'' =  U(j-1)-2*U(j)+U(j+1)
% notice that spacing h between the nodes is not used. The caller must
% divide by h^2 this A matrix abone return.
%
% INPUT:  N, the number of nodes
% OUTPUT: A, the matrix , see below
%
% EXAMPLE:
% A = nma_FDM_matrix_laplace_1D_dirichlet(6)
%
%     -2     1     0     0     0     0
%      1    -2     1     0     0     0
%      0     1    -2     1     0     0
%      0     0     1    -2     1     0
%      0     0     0     1    -2     1
%      0     0     0     0     1    -2
%
% A = A/h^2;  % h is space between points
% U = A\f;  % solve for U, where Uxx=f, need to set f as function before.
%

A = zeros(N);

for i=1:N
    for j=1:N
        if(i==j)
            A(i,j) = -2;
        else
            if( i==j+1 || i==j-1 )
                A(i,j) = 1;
            end
        end
    end
end

end

