function nma_CG_TEST2
% another driver for nma_CG.m

% this compares my solution with that found by matlab
% pcg() function. Matlab pcg() function seems to use 
% no preconditioning.
%
% Nasser M. Abbasi

close all;
%myforce = @(X,Y) -exp( -(X-0.25).^2 - (Y-0.6).^2 );

%myforce = @(X,Y) exp(X).*sin(Y);
myforce = @(X,Y) -exp( -(X-0.25).^2 - (Y-0.6).^2 );
max_iterations = 500;
tol   = 1e-6;
h     = 1/32;
n     = (1/h + 1);
nx    = n-2; %internal grid points
[A,f] = nma_GENP2D(nx,myforce);

[x1,flag1,rr1,iter1,rv1] = pcg(-A,f,tol,max_iterations );
figure();
subplot(2,1,1);
u=reshape(-x1,nx,nx);
mesh(u);
title(sprintf('solution by matlab, iterations=%d',iter1));

subplot(2,1,2);
[u, nIter, result, cond_MA, cond_M, cond_A, eig_MA ,eig_M, eig_A] =...
   nma_CG( -A, f, tol, max_iterations,'NONE', 0.01 );
u=reshape(-x1,nx,nx);
mesh(u);
title(sprintf('solution by nma CG, iterations=%d',nIter));

end

