function [] = nma_CG_GUI_TEST()
%GUI for conjugate gradient solver

% 12/15/2010  version
% simple GUI front end to the nma_CG() solver, to solve
% 2D poisson problem using conjugate gradient method with
% preconditioning
% Nasser M. Abbasi

s.fh = figure('Units','normalized',...
   'position',[.25 .25 .6 .55],...
   'name','Poisson 2D conjugate gradient solver on unit square',...
   'numbertitle','on',...
   'resize','off');

%--- preconditioners
s.solvers = uicontrol('Parent',s.fh,...
   'style','list',...
   'unit','normalized',...
   'position',[.01 .75 .275 .20],...
   'Min',0,'Max',1,...
   'fontsize',9,...
   'string',{'NONE';'SSOR';'MULTI-GRID'; 'INCOMPLETE-CHOLESKY'});

s.solvers_label = uicontrol('Parent',s.fh,...,...
   'style','text',...
   'Units','normalized',...
   'Position',[.01 .70 .275 .05],...
   'String','select pre-conditioning',...
   'fontsize',9,'FontWeight','bold',...
   'BackgroundColor','white');

%---- tolerance
s.tol = uicontrol('Parent',s.fh,...,...
   'style','edit',...
   'Units','normalized',...
   'Position',[.01 .625 .275 .05],...
   'String','10^-7',...
   'HorizontalAlignment','left',...
   'fontsize',9,'FontWeight','bold');

s.tol_label = uicontrol('Parent',s.fh,...,...
   'style','text',...
   'Units','normalized',...
   'Position',[.01 .575 .275 .05],...
   'String','convergence tolerance',...
   'fontsize',9,'FontWeight','bold',...
   'BackgroundColor','white');

%---- number of grid points
s.n = uicontrol('Parent',s.fh,...
   'style','list',...
   'unit','normalized',...
   'position',[.01 .45 .1 .1],...
   'Min',0,'Max',1,...
   'fontsize',9,...
   'string',{'5';'9';'17';'33';'65';'129'});

s.n_label = uicontrol('Parent',s.fh,...,...
   'style','text',...
   'Units','normalized',...
   'Position',[.01 .38 .105 .06],...
   'String','grid points',...
   'HorizontalAlignment','left',...
   'fontsize',9,'FontWeight','bold',...
   'BackgroundColor','white');


%----- plot axis
s.hax = axes('parent',s.fh,'Position',[.4,.2,.55,.65]);


%---- forcing function
s.force = uicontrol('Parent',s.fh,...
   'style','edit',...
   'unit','normalized',...
   'HorizontalAlignment','left',...
   'position',[.01 .135 .4 .1],...
   'fontsize',12,...
   'string','sin(X).^2 + cos(X)');

s.force_label = uicontrol('Parent',s.fh,...,...
   'style','text',...
   'Units','normalized',...
   'Position',[.01 .07 .05 .05],...
   'String','force',...
   'HorizontalAlignment','left',...
   'fontsize',9,'FontWeight','bold',...
   'BackgroundColor','white');

%---- run button
s.run = uicontrol('Parent',s.fh,...
   'Style','pushbutton',...
   'units','normalized',...
   'position',[.01 .25 .1 .1],...
   'fontsize',10,...
   'string','Run',...
   'callback',{@run_btn_callback,s});

%----------------------------------
   function []=run_btn_callback(varargin)
      s = varargin{3};
      h = s.tol;
      tolStr = get(h,'String');
      tol = str2num(tolStr);
      
      if isnan(tol)
         errordlg('You must enter a numeric value for tolerance',...
            'Bad Input','modal');
         uicontrol(h);
         return
      else
         fprintf('tolerance = %s\n',tolStr);
      end
      
      h = s.n;
      nStr = get(h,'String');
      v =  get(h,'Value');
      n = str2double(nStr{v});
      fprintf('n = %d\n',n);
      
      h = s.solvers;
      solver = get(h,'String');
      v =  get(h,'Value');
      solver=solver{v};
      fprintf('solver = %s\n',solver);
      
      h = s.force;
      forceStr = strtrim(get(h,'String'));
      fprintf('force = %s\n',forceStr);
      
      nx = n-2;
      if strcmp(forceStr, '0')
         forceStr='0.*X';
      end
      
      forceStr=['@(X,Y)' forceStr];
      fh=str2func(forceStr);
      [A,f] = nma_GENP2D(nx,fh);
      [u, nIter, result, cond_MA, cond_M, cond_A, eig_MA ,eig_M, eig_A] =...
         nma_CG( -A, f, tol, 200,  solver, s.hax,0.001);
      u=reshape(-u,nx,nx);
      
      mesh(s.hax,u);
      title(sprintf('final solution, iterations used %d',nIter));
   end

end

