!  GLUT Fortran 90 program to draw line
!  Nasser M. Abbasi  072312, gfortran 4.6.3

!------------------------------------
PROGRAM simple2
USE opengl_glut
USE opengl_gl
USE ISO_C_BINDING
IMPLICIT none

INTEGER :: i
REAL    :: g_spin= 0.0

CALL glutInit()
CALL glutInitDisplayMode(GLUT_DOUBLE+GLUT_RGB)
CALL glutInitWindowSize( 350, 350 );
CALL glutInitWindowPosition( 100, 100 );
i =  glutCreateWindow( "left mouse to rotate, middle to stop" );

!-- init
CALL glClearColor(0.,0.,0.,0.) !-- background color
CALL glShadeModel(GL_FLAT)
	
CALL glutDisplayFunc(display)  !-- callback to draw 
CALL glutReshapeFunc(reshape) 
CALL glutMouseFunc(mouse) 
CALL glutMainLoop

CONTAINS
!---------------
SUBROUTINE display() bind(c)
CHARACTER(LEN=20) :: st
INTEGER :: i

CALL glClear(GL_COLOR_BUFFER_BIT+GL_DEPTH_BUFFER_BIT)
CALL glPushMatrix()
CALL glRotatef(g_spin, 0.0 ,0.0 ,1.0)
CALL glColor3f(1., 1.,1.)
CALL glRectf(-25.0,-25.0,25.0, 25.0)
CALL glPopMatrix()

CALL glRasterPos3f(0.,40.,0.0);

Write( st, '( f12.8 )' ) g_spin
DO i=1,LEN(TRIM(st))   
   CALL glutBitmapCharacter(GLUT_BITMAP_9_BY_15,ICHAR(st(i:i)));
END DO

CALL glutSwapBuffers()

END SUBROUTINE display

!------------------------------
SUBROUTINE reshape(w,h) bind(c)
INTEGER (C_INT), VALUE :: w
INTEGER (C_INT), VALUE :: h     

CALL glViewport(0, 0,  w,  h);
CALL glMatrixMode(GL_PROJECTION);
CALL glLoadIdentity();
CALL glOrtho(-50.0d0, 50.0d0, -50.0d0, 50.0d0, -1.0d0, 1.0d0);
CALL glMatrixMode(GL_MODELVIEW);
CALL glLoadIdentity();

END SUBROUTINE reshape

!------------------------------
SUBROUTINE mouse(button,state,x,y) bind(c)
INTEGER (C_INT), VALUE :: button
INTEGER (C_INT), VALUE :: state
INTEGER (C_INT), VALUE :: x
INTEGER (C_INT), VALUE :: y    

SELECT CASE(button) 
       CASE(GLUT_LEFT_BUTTON) 
         IF (state .EQ. GLUT_DOWN) THEN
            CALL glutIdleFunc(spinDisplay)
         END IF
       CASE(GLUT_MIDDLE_BUTTON)
         IF (state .EQ. GLUT_DOWN) THEN
            CALL glutIdleFunc()
         END IF
END SELECT       
END SUBROUTINE mouse

!------------------------------
SUBROUTINE spinDisplay() bind(c)

g_spin = g_spin + 0.5
IF (g_spin>360.0) THEN
   g_spin = g_spin - 360.0
END IF

CALL glutPostRedisplay()       
END SUBROUTINE spinDisplay


END PROGRAM simple2

