#!/bin/bash



#where the F03G binding is located
BINDING_DIR=/media/nabbasi/data/fortran_related/f03gl/f03gl 

#the compile flags
FFLAGS="-Wall -Wextra -pedantic -fcheck=all 
        -fcheck=do -fwhole-file -funroll-loops -ftree-vectorize  
        -Wsurprising -Wconversion -Wconversion-extra
        -I$BINDING_DIR"


#The openGL and X libraries list
F90GLUTLIB="/usr/lib/libglut.a 
            /usr/lib/i386-linux-gnu/mesa/libGL.a
            /usr/lib/i386-linux-gnu/libGLU.a"

#directory where X libraries are
X11DIR=/usr/lib/i386-linux-gnu

#names of all the X libraries
X11LIB="$X11DIR/libXaw7.a
        $X11DIR/libXt.a 
        $X11DIR/libXmu.a 
        $X11DIR/libXi.a 
        $X11DIR/libXext.a 
        $X11DIR/libX11.a
        $X11DIR/libm.a"
        
LIBS="$F90GLUTLIB 
      $X11LIB  
       /usr/lib/gcc/i686-linux-gnu/4.6/libgfortran.a      
       $X11DIR/libdl.a
       /usr/gnat/lib/libstdc++.a
       $X11DIR/libxcb.a
       $X11DIR/libXau.a
       $X11DIR/libXdmcp.a
       $X11DIR/libpthread.a"

#names of the F03G object files
MODULES="$BINDING_DIR/glut_fonts.o 
         $BINDING_DIR/opengl_kinds.o 
         $BINDING_DIR/opengl_freeglut.o 
         ${BINDING_DIR}/opengl_glu.o 
         $BINDING_DIR/opengl_gl.o"


#gfortran -Wall -c -I$BINDING_DIR -I. stars_mod.f90  
#gfortran -Wall stars.f90 stars_mod.o -static $MODULES $LIBS -o stars

#gfortran $FFLAGS -c -fno-range-check -I$BINDING_DIR  scube_mod.f90  
#gfortran $FFLAGS scube.f90 scube_mod.o -static $MODULES $LIBS -o scube


#gfortran $FFLAGS -c -fno-range-check -I$BINDING_DIR  view_modifier.f90  
#gfortran $FFLAGS -c -fno-range-check -I$BINDING_DIR  function_plotter.f90  
#gfortran $FFLAGS plotfunc.f90 view_modifier.o function_plotter.o -static $MODULES $LIBS -o plotfunc


#gfortran $FFLAGS -c -fno-range-check -I$BINDING_DIR  view_modifier.f90  
#gfortran $FFLAGS -c -fno-range-check -I$BINDING_DIR  view_demo_callbacks.f90  
#gfortran $FFLAGS view_demo.f90 view_demo_callbacks.o view_modifier.o -static $MODULES $LIBS -o view_demo

#gfortran $FFLAGS -c  -I$BINDING_DIR  blender.f90  
#gfortran $FFLAGS blender_main.f90 blender.o -static $MODULES $LIBS -o blender_main


gfortran $FFLAGS -c  -I$BINDING_DIR  RandomSphere_FreeGLUT.f90  
gfortran $FFLAGS randomspher_freeglut_main.f90 RandomSphere_FreeGLUT.o -static $MODULES $LIBS -o randomspher_freeglut_main



