#!/bin/bash

PGM=simple3

#where the F03G binding is located
BINDING_DIR=/media/nabbasi/data/fortran_related/f03gl/f03gl

#the compile flags
FFLAGS="-Wall -Wextra -pedantic -fcheck=all 
        -fcheck=do -fwhole-file -funroll-loops -ftree-vectorize  
        -Wsurprising -Wconversion -Wconversion-extra 
        -I$BINDING_DIR"

#compile it
gfortran $FFLAGS -c ${PGM}.f90

#The openGL and X libraries list
F90GLUTLIB="/usr/lib/libglut.so 
            /usr/lib/i386-linux-gnu/libGL.so 
            /usr/lib/i386-linux-gnu/libGLU.so"

#directory where X libraries are
X11DIR=/usr/lib/i386-linux-gnu

#names of all the X libraries
X11LIB="$X11DIR/libXaw7.so.7 
        $X11DIR/libXt.so 
        $X11DIR/libXmu.so 
        $X11DIR/libXi.so 
        $X11DIR/libXext.so 
        $X11DIR/libX11.so 
        $X11DIR/libm.so
        $X11DIR/libXau.so"
        
LIBS="$F90GLUTLIB 
      $X11LIB  
      $X11DIR/libgfortran.so
      $X11DIR/libpthread.so
      $X11DIR/libdl.so
      /usr/gnat/lib/libstdc++.so"

#names of the F03G object files
MODULES="$BINDING_DIR/glut_fonts.o 
         $BINDING_DIR/opengl_kinds.o 
         $BINDING_DIR/opengl_freeglut.o 
         ${BINDING_DIR}/opengl_glu.o 
         $BINDING_DIR/opengl_gl.o"

#link it
gfortran -Wall ${PGM}.o $MODULES $LIBS -o ${PGM}

