-- example showing how to call LAPACK from Ada
-- Nasser M. Abbasi July 26, 2012
-- to build do  
-- cd lapada/test/piolt
-- gnatmake -I../../binding/src mysolve.adb -largs -L../../binding/obj -L/usr/lib -lblas -llapack


with Ada.Text_IO; use Ada.Text_IO;

with Interfaces.Fortran; use Interfaces.Fortran;
with lapack;

procedure mysolve is

   A    : lapack.Fortran_Real_Matrix (1 .. 3, 1 .. 3);
   b    : lapack.Fortran_Real_Matrix (1 .. 3, 1 .. 1);
   info : Fortran_Integer;
   ipiv : lapack.Fortran_Integer_Vector (1 .. A'Last (2));

begin -- solve A x=b

   A := ((2.0, 3.0, 1.0), (2.0, 1.0, 1.0), (4.0, -1.0, 6.0));

   b := ((1 => 9.0), (1 => 2.0), (1 => -2.0));

   lapack.SGESV
     (N    => A'Last (2),
      NRHS => b'Last (2),
      A    => A,
      LDA  => A'Last (1),
      IPIV => ipiv,
      B    => b,
      LDB  => b'Last (1),
      INFO => info);

   if (info /= 0) then
      raise Program_Error;
   end if;

   declare
      package real_iO is new Ada.Text_IO.Float_IO (Real);
   begin
      for I in b'Range (1) loop
         real_iO.Put (b (I, 1));
         New_Line;
      end loop;
   end;

end mysolve;
