--  Program to demonstrate how to import Fortran subroutine 
--  into Ada language. 
--  Check  exception

with Ada.Text_IO; 
use  Ada.Text_IO;
with Interfaces.Fortran; 
use  Interfaces.Fortran;
with lap4; use lap4;

procedure lap42 is 

	use Real_IO;

	N:   Fortran_Integer := 3;
	A,X: Fortran_Real_Matrix ( 1..N, 1..N );
	B,Y: Fortran_Real_Matrix ( 1..N, 1..N );
	Z:   Fortran_Real_Matrix ( 1..N, 1..N );
	
	ERR  : Real := 0.0;

begin 

	-- A is singular, exception shold raise
	A := ((2.0,  1.0,  1.0),
              (2.0,  1.0,  1.0),
              (4.0, -1.0,  6.0));

	B := (( 9.0,  9.0, 16.0),
	      ( 2.0, -2.0,  4.0),
	      ( 5.0,  8.0,-11.0));

	X := A;
	Y := B;

	SGESV (	
          	A    => A,
          	B    => B);

        for I in Z'Range (1) loop
	   for J in Z'Range(2) loop
	      Z(I,J) := 0.0;
	      for K in X'Range(2) loop
		 Z(I,J) := Z(I,J) + ( X(I,K) * B(K,J));
	      end loop;
	      ERR := ERR + abs (Z(I,J) - Y(I,J));
	   end loop;
	end loop;

	PUT ( "Abs Error:");
	PUT ( ERR );
	New_line;

end lap42;