--  Program to demonstrate how to import Fortran subroutine 
--  into Ada language. 
--  Add procedure body to reduce number of parameter
--  and use exception rather than INFO value.

with Ada.Text_IO; 
use  Ada.Text_IO;

with Interfaces.Fortran; 
use  Interfaces.Fortran;

package lap4 is 


	-- Fortran data type with convention FORTRAN
	type Fortran_Integer_Vector is array (Fortran_Integer range <>) 
         	of Fortran_Integer;
	pragma Convention (Fortran, Fortran_Integer_Vector);

	type Fortran_Real_Vector is array (Fortran_Integer range <>) 
         of Real;
	pragma Convention (Fortran, Fortran_Real_Vector);

 	type Fortran_Real_Matrix is array (Fortran_Integer range <>,
		Fortran_Integer range <>) of Real;
	pragma Convention (Fortran, Fortran_Real_Matrix);

	-- IO
        package Real_IO is new Ada.Text_IO.Float_IO( Real );

	-- Specification of Imported function
	procedure SGESV (
        N        : Fortran_Integer;
        NRHS     : Fortran_Integer;
        A        : Fortran_Real_Matrix;
        LDA      : Fortran_Integer;
        IPIV     : out Fortran_Integer_Vector;
        B        : Fortran_Real_Matrix;
        LDB      : Fortran_Integer;
        INFO     : out Fortran_Integer );

	-- Import here
	pragma Import ( Fortran, SGESV, "sgesv_");

	-- Overload name and reduce parameter
	-- need to write procedure body
	procedure SGESV (
        A        : Fortran_Real_Matrix;
        B        : Fortran_Real_Matrix );

	illegal_value: exception;
	singular : exception;

end lap4;