-- Reduce number of parameter by useing known value
-- from array attribute.
-- Exception routine rather than INFO value.

with Interfaces.Fortran;
use  Interfaces.Fortran;


package body lap4 is 


	procedure SGESV (
       		A : Fortran_Real_Matrix;
        	B : Fortran_Real_Matrix ) is 

        IPIV : Fortran_Integer_Vector ( 1..A'Last(2)); 
        INFO : Fortran_Integer;

	begin 
         SGESV ( N   => A'Last(2),
                NRHS => B'Last(2),
                A    => A,
                LDA  => A'Last(1),
                IPIV => IPIV,
                B    => B,
                LDB  => B'Last(1),
                INFO => INFO);

	if ( INFO < 0 ) then 
	   raise illegal_value;
	end if;

	if ( INFO > 0 ) then 
	   raise singular;
	end if;

	end SGESV;
end lap4;
