--  Program to demonstrate how to import Fortran subroutine 
--  into Ada language. 
--  Test of rename two function in to one entry point

with Ada.Text_IO;  use  Ada.Text_IO;
with Interfaces.Fortran;  use  Interfaces.Fortran;
with lap3; use lap3;

procedure lap31 is 

	use Real_IO;
	use Double_Precision_IO;

	N:   Fortran_Integer := 3;

	AS,XS: Fortran_Real_Matrix ( 1..N, 1..N );
	BS,YS: Fortran_Real_Matrix ( 1..N, 1..N );
	ZS   : Fortran_Real_Matrix ( 1..N, 1..N );
	
	ERRS  : Real := 0.0;

	AD,XD: Fortran_Double_Precision_Matrix ( 1..N, 1..N );
	BD,YD: Fortran_Double_Precision_Matrix ( 1..N, 1..N );
	ZD   : Fortran_Double_Precision_Matrix ( 1..N, 1..N );
	
	ERRD  : Double_Precision := 0.0;

	IPIV : Fortran_Integer_Vector ( 1..N ); 
	INFO : Fortran_Integer;

begin 

	-- Real number call
	AS := ((2.0,  1.0,  1.0),
              (2.0,  2.0, -1.0),
              (4.0, -1.0,  6.0));

	BS := (( 9.0,  9.0, 16.0),
	      ( 2.0, -2.0,  4.0),
	      ( 5.0,  8.0,-11.0));

	XS := AS;
	YS := BS;

	GESV (	N    => N,
          	NRHS => N,
          	A    => AS,
          	LDA  => N,
          	IPIV => IPIV,
          	B    => BS,
          	LDB  => N,
          	INFO => INFO);

        if (INFO /= 0) then 
           Put_line ("ERROR");
        end if;

        for I in ZS'Range (1) loop
	   for J in ZS'Range(2) loop
	      ZS(I,J) := 0.0;
	      for K in XS'Range(2) loop
		 ZS(I,J) := ZS(I,J) + ( XS(I,K) * BS(K,J));
	      end loop;
	      ERRS := ERRS + abs (ZS(I,J) - YS(I,J));
	   end loop;
	end loop;

	PUT ( "Abs Error:");
	PUT ( ERRS );
	New_line;

	-- Double precision here
	AD := ((2.0,  1.0,  1.0),
              (2.0,  2.0, -1.0),
              (4.0, -1.0,  6.0));

	BD := (( 9.0,  9.0, 16.0),
	      ( 2.0, -2.0,  4.0),
	      ( 5.0,  8.0,-11.0));

	XD := AD;
	YD := BD;

	DGESV (	N    => N,	
          	NRHS => N,
          	A    => AD,
          	LDA  => N,
          	IPIV => IPIV,
          	B    => BD,
          	LDB  => N,
          	INFO => INFO);

        if (INFO /= 0) then 
           Put_line ("ERROR");
        end if;

        for I in ZD'Range (1) loop
	   for J in ZD'Range(2) loop
	      ZD(I,J) := 0.0;
	      for K in XD'Range(2) loop
		 ZD(I,J) := ZD(I,J) + ( XD(I,K) * BD(K,J));
	      end loop;
	      ERRD := ERRD + abs (ZD(I,J) - YD(I,J));
	   end loop;
	end loop;

	PUT ( "Abs Error:");
	PUT ( ERRD );
	New_line;

end lap31;
