--  Program to demonstrate how to import Fortran subroutine 
--  into Ada language. 
--  Two function rename as one entry point.

with Ada.Text_IO;  use  Ada.Text_IO;
with Interfaces.Fortran;  use  Interfaces.Fortran;

package lap3 is 

	-- Fortran data type with convention FORTRAN
	type Fortran_Integer_Vector is array (Fortran_Integer range <>) 
         	of Fortran_Integer;
	pragma Convention (Fortran, Fortran_Integer_Vector);

	type Fortran_Real_Vector is array (Fortran_Integer range <>) 
         of Real;
	pragma Convention (Fortran, Fortran_Real_Vector);

 	type Fortran_Real_Matrix is array (Fortran_Integer range <>,
		Fortran_Integer range <>) of Real;
	pragma Convention (Fortran, Fortran_Real_Matrix);

	type Fortran_Double_Precision_Vector is array 
	 (Fortran_Integer range <>) of Double_Precision;
	pragma Convention (Fortran, Fortran_Double_Precision_Vector);

    	type Fortran_Double_Precision_Matrix is array 
	 (Fortran_Integer range <>,Fortran_Integer range <>) 
         of Double_Precision;
	pragma Convention (Fortran, Fortran_Double_Precision_Matrix);

	-- IO
        package Real_IO is new Ada.Text_IO.Float_IO( Real );

	package Double_Precision_IO is 
        new Ada.Text_IO.Float_IO( Double_Precision );

	-- Specification of Imported function
	procedure SGESV (
        N        : Fortran_Integer;
        NRHS     : Fortran_Integer;
        A        : Fortran_Real_Matrix;
        LDA      : Fortran_Integer;
        IPIV     : out Fortran_Integer_Vector;
        B        : Fortran_Real_Matrix;
        LDB      : Fortran_Integer;
        INFO     : out Fortran_Integer );

	pragma Import ( Fortran, SGESV, "sgesv_");
	
	procedure DGESV (
        N        : Fortran_Integer;
        NRHS     : Fortran_Integer;
        A        : Fortran_Double_Precision_Matrix;
        LDA      : Fortran_Integer;
        IPIV     : out Fortran_Integer_Vector;
        B        : Fortran_Double_Precision_Matrix;
        LDB      : Fortran_Integer;
        INFO     : out Fortran_Integer );

	pragma Import ( Fortran, DGESV, "dgesv_");

	-- Rename here
        procedure GESV (
        N        : Fortran_Integer;
        NRHS     : Fortran_Integer;
        A        : Fortran_Real_Matrix;
        LDA      : Fortran_Integer;
        IPIV     : out Fortran_Integer_Vector;
        B        : Fortran_Real_Matrix;
        LDB      : Fortran_Integer;
        INFO     : out Fortran_Integer )
	renames SGESV;

        procedure GESV (
        N        : Fortran_Integer;                
        NRHS     : Fortran_Integer;
        A        : Fortran_Double_Precision_Matrix;
        LDA      : Fortran_Integer;
        IPIV     : out Fortran_Integer_Vector;
        B        : Fortran_Double_Precision_Matrix;
        LDB      : Fortran_Integer;
        INFO     : out Fortran_Integer )
	renames DGESV;


end lap3;
