--  Program to demonstrate how to import Fortran subroutine 
--  into Ada language. 
--  As lap21 and test subtype

with Ada.Text_IO;  use  Ada.Text_IO;
with Interfaces.Fortran;  use  Interfaces.Fortran;
with lap2; use lap2;

procedure lap22 is 

	use Real_IO;

	-- Subtype testing

	N:   Fortran_Integer := 3;
	subtype SMatrix is Fortran_Real_Matrix( 1..N, 1..N ); 

	A,X: SMatrix;
	B,Y: SMatrix;
	Z:   SMatrix;
	
	ERR  : Real := 0.0;
	IPIV : Fortran_Integer_Vector ( 1..N ); 
	INFO : Fortran_Integer;

begin 
	A := ((2.0,  1.0,  1.0),
              (2.0,  2.0, -1.0),
              (4.0, -1.0,  6.0));

	B := (( 9.0,  9.0, 16.0),
	      ( 2.0, -2.0,  4.0),
	      ( 5.0,  8.0,-11.0));

	X := A;
	Y := B;

	SGESV (	N    => N,
          	NRHS => N,
          	A    => A,
          	LDA  => N,
          	IPIV => IPIV,
          	B    => B,
          	LDB  => N,
          	INFO => INFO);

        if (INFO /= 0) then 
           Put_line ("ERROR");
        end if;

        for I in Z'Range (1) loop
	   for J in Z'Range(2) loop
	      Z(I,J) := 0.0;
	      for K in X'Range(2) loop
		 Z(I,J) := Z(I,J) + ( X(I,K) * B(K,J));
	      end loop;
	      ERR := ERR + abs (Z(I,J) - Y(I,J));
	   end loop;
	end loop;

	PUT ( "Abs Error:");
	PUT ( ERR );
	New_line;

end lap22;
