--  Program to demonstrate further uses of pragma Import. 

with Ada.Text_IO;  use  Ada.Text_IO;
with Interfaces.Fortran;  use  Interfaces.Fortran;

package lap2 is 

	-- Linker options for easier to use 
	-- or else need to put in compile step
	-- which is sometime didn't work 

	--pragma Linker_Options ("-llapack");
	--pragma Linker_Options ("-lblas");

	-- pragma Linker_Options ("-lf2c");    
	--pragma Linker_Options ("-lgfortran");   
	--pragma Linker_Options ("-lm");
	--pragma Linker_Options ("-static");


	-- Fortran data type with convention FORTRAN
	type Fortran_Integer_Vector is array (Fortran_Integer range <>) 
         	of Fortran_Integer;
	pragma Convention (Fortran, Fortran_Integer_Vector);

	type Fortran_Real_Vector is array (Fortran_Integer range <>) 
         of Real;
	pragma Convention (Fortran, Fortran_Real_Vector);

 	type Fortran_Real_Matrix is array (Fortran_Integer range <>,
		Fortran_Integer range <>) of Real;
	pragma Convention (Fortran, Fortran_Real_Matrix);

	-- IO
        package Real_IO is new Ada.Text_IO.Float_IO( Real );

	-- Specification of Imported function
	procedure SGESV (
        N        : Fortran_Integer;
        NRHS     : Fortran_Integer;
        A        : Fortran_Real_Matrix;
        LDA      : Fortran_Integer;
        IPIV     : out Fortran_Integer_Vector;
        B        : Fortran_Real_Matrix;
        LDB      : Fortran_Integer;
        INFO     : out Fortran_Integer );

	-- Import here
	pragma Import ( Fortran, SGESV, "sgesv_");

end lap2;
