--  Program to demonstrate use of pragma import
--  to invoke Fortran subroutine from  Ada95 program. 

with Ada.Text_IO;  use  Ada.Text_IO;
with Interfaces.Fortran; use  Interfaces.Fortran;

procedure Lap1 is 
	
	-- Fortran data type with convention FORTRAN
	type Fortran_Integer_Vector is array (Fortran_Integer range <>) 
         	of Fortran_Integer;
	pragma Convention (Fortran, Fortran_Integer_Vector);

	type Fortran_Real_Vector is array (Fortran_Integer range <>) 
         of Real;
	pragma Convention (Fortran, Fortran_Real_Vector);

 	type Fortran_Real_Matrix is array (Fortran_Integer range <>,
		Fortran_Integer range <>) of Real;
	pragma Convention (Fortran, Fortran_Real_Matrix);

	-- IO
        package Real_IO is new Ada.Text_IO.Float_IO( Real );
	use Real_IO;

	-- Specification of Imported function
	procedure SGESV (
        N        : Fortran_Integer;
        NRHS     : Fortran_Integer;
        A        : Fortran_Real_Matrix;
        LDA      : Fortran_Integer;
        IPIV     : out Fortran_Integer_Vector;
        B        : Fortran_Real_Matrix;
        LDB      : Fortran_Integer;
        INFO     : out Fortran_Integer );

	-- Import here
	pragma Import ( Fortran, SGESV, "sgesv_");

	N:   Fortran_Integer := 3;
	A,X: Fortran_Real_Matrix ( 1..N, 1..N );
	B,Y: Fortran_Real_Matrix ( 1..N, 1..N );
	Z:   Fortran_Real_Matrix ( 1..N, 1..N );
	
	ERR  : Real := 0.0;
	IPIV : Fortran_Integer_Vector ( 1..N ); 
	INFO : Fortran_Integer;

begin 
	A := ((2.0,  1.0,  1.0),
              (2.0,  2.0, -1.0),
              (4.0, -1.0,  6.0));

	B := (( 9.0,  9.0, 16.0),
	      ( 2.0, -2.0,  4.0),
	      ( 5.0,  8.0,-11.0));

	X := A;
	Y := B;

	SGESV (	N    => N,
          	NRHS => N,
          	A    => A,
          	LDA  => N,
          	IPIV => IPIV,
          	B    => B,
          	LDB  => N,
          	INFO => INFO);

        if (INFO /= 0) then 
           Put_line ("ERROR");
        end if;

        for I in Z'Range (1) loop
	   for J in Z'Range(2) loop
	      Z(I,J) := 0.0;
	      for K in X'Range(2) loop
		 Z(I,J) := Z(I,J) + ( X(I,K) * B(K,J));
	      end loop;
	      ERR := ERR + abs (Z(I,J) - Y(I,J));
	   end loop;
	end loop;

	PUT ( "Abs Error:");
	PUT ( ERR );
	New_line;

end Lap1;
