with Ada.Text_IO; 
use  Ada.Text_IO;
with Interfaces.Fortran; 
use  Interfaces.Fortran;
with lapack; 

procedure tsgels is 

        use lapack.Real_IO;

	N: Fortran_Integer := 3;
        LWORK : Fortran_Integer := 2 * N;
	A,X: lapack.Fortran_Real_Matrix ( 1..N, 1..N );
	B,Y: lapack.Fortran_Real_Matrix ( 1..N, 1..N );
	Z: lapack.Fortran_Real_Matrix ( 1..N, 1..N );

	WORK: lapack.Fortran_Real_Vector ( 1..LWORK);

	ERR: Real := 0.0;

	INFO : Fortran_Integer;
begin 
	A := ((2.0,  1.0,  1.0),
              (2.0,  2.0, -1.0),
              (4.0, -1.0,  6.0));

	B := (( 9.0,  9.0, 16.0),
	      ( 2.0, -2.0,  4.0),
	      ( 5.0,  8.0,-11.0));


	X := A;
	Y := B;

	
lapack.SGELS (
        TRANS    => 'N',
        M        => N,
        N        => N,
        NRHS     => N,
        A        => A,
        LDA      => N,
        B        => B,
        LDB      => N,
        WORK     => WORK,
        LWORK    => LWORK,
        INFO     => INFO );


        if (INFO /= 0) then 
           Put_line ("ERROR");
        end if;

        for I in Z'Range (1) loop
	   for J in Z'Range(2) loop
	      Z(I,J) := 0.0;
	      for K in X'Range(2) loop
		 Z(I,J) := Z(I,J) + ( X(I,K) * B(K,J));
	      end loop;
	      ERR := ERR + abs (Z(I,J) - Y(I,J));
	   end loop;
	end loop;

	PUT ( "Abs Error:");
	PUT ( ERR );
	New_line;

end tsgels;


