with Ada.Text_IO; 
use  Ada.Text_IO;
with Interfaces.Fortran; 
use  Interfaces.Fortran;
with lapack; use  lapack;

procedure tzspsv is 

    use lapack.Double_Precision_IO;

	N: Fortran_Integer := 3;
	A: Fortran_Complex_Star_16_Matrix ( 1..N, 1..N );

	AP : Fortran_Complex_Star_16_Vector ( 1..6 );

	B,Y: Fortran_Complex_Star_16_Matrix ( 1..N, 1..N );
	Z: Fortran_Complex_Star_16_Matrix ( 1..N, 1..N );

	IPIV: Fortran_Integer_Vector ( 1..N );

	ERR: Double_Precision := 0.0;
	INFO : Fortran_Integer;
begin 
   
        -- A is symmetric  metric
        A := (( ( 2.0, 1.0), ( 1.0, 5.0), (-2.0,-1.0)),
              ( ( 1.0, 5.0), ( 2.0,-4.0), (-1.0,-1.0)),
              ( (-2.0,-1.0), (-1.0,-1.0), ( 6.0, 3.0)));

        -- AP is packed  arrays
        AP := ( A(1,1), A(1,2), A(2,2), A(1,3), A(2,3), A(3,3));

        B := (( (9.0, 3.0), ( 9.0, 7.0), ( 16.0, 11.0)),
              ( (2.0, 7.0), (-2.0,-1.0), ( -4.0,  4.0)),
              ( (5.0,-2.0), ( 8.0, 2.0), (-11.0, -3.0)));

	Y := B;

	ZSPSV (
        UPLO     => 'U',
        N        => N,
        NRHS     => N,
        AP       => AP,
        IPIV     => IPIV,
        B        => B,
        LDB      => N,
        INFO     => INFO );

	if (INFO /= 0) then 
	   Put_line ("ERROR");
	end if;


        for I in Z'Range (1) loop
	   for J in Z'Range(2) loop
	      Z(I,J) := (0.0,0.0);
	      for K in A'Range(2) loop
		 Z(I,J) := Z(I,J) + ( A(I,K) * B(K,J));
	      end loop;
	      ERR := ERR + abs (Z(I,J) - Y(I,J));
	   end loop;
	end loop;

        -- PUT (Y);
        -- PUT (Z);
	PUT ( "Abs Error:");
	PUT ( ERR );
	New_line;

end tzspsv;



