with Ada.Text_IO; 
use  Ada.Text_IO;
with Interfaces.Fortran; 
use  Interfaces.Fortran;
with lapack; use  lapack;


procedure tzptsv is 

    use lapack.Double_Precision_IO;

	N: Fortran_Integer := 3;
	A: Fortran_Complex_Star_16_Matrix ( 1..N, 1..N );

	E : Fortran_Complex_Star_16_Vector ( 1..N-1 );
	D : Fortran_Double_Precision_Vector ( 1..N );

	B,Y: Fortran_Complex_Star_16_Matrix ( 1..N, 1..N );
	Z: Fortran_Complex_Star_16_Matrix ( 1..N, 1..N );
	
	ERR: Double_Precision := 0.0;
	INFO : Fortran_Integer;
begin 
   
        -- A is  Hermitian  positive definite tridiagonal metric
        A := (( ( 3.0, 0.0), ( 1.0,-2.0), ( 0.0, 0.0)),
              ( ( 1.0,+2.0), ( 4.0, 0.0), ( 0.0, 2.0)),
              ( ( 0.0, 0.0), ( 0.0,-2.0), ( 2.0, 0.0)));

	-- D, E are tridiagonal arrays
	E :=  (A(2,1),A(3,2));
	D :=  (Re(A(1,1)),Re(A(2,2)),Re(A(3,3)));
	
        B := (( (9.0, 3.0), ( 9.0, 7.0), ( 16.0, 11.0)),
              ( (2.0, 2.0), (-1.0,-2.0), ( -1.0,  4.0)),
              ( (5.0,-2.0), ( 8.0, 2.0), (-11.0, -3.0)));

	Y := B;

	ZPTSV (
	N	 => N,
	NRHS	 => N,
	D	 => D,
	E	 => E,
	B	 => B,
	LDB	 => N,
	INFO	 => INFO );

	if (INFO /= 0) then 
	   Put_line ("ERROR");
	end if;


        for I in Z'Range (1) loop
	   for J in Z'Range(2) loop
	      Z(I,J) := (0.0,0.0);
	      for K in A'Range(2) loop
		 Z(I,J) := Z(I,J) + ( A(I,K) * B(K,J));
	      end loop;
	      ERR := ERR + abs (Z(I,J) - Y(I,J));
	   end loop;
	end loop;

        -- PUT (Y);
        -- PUT (Z);
	PUT ( "Abs Error:");
	PUT ( ERR );
	New_line;

end tzptsv;



