with Ada.Text_IO;
use  Ada.Text_IO;
with Interfaces.Fortran;
use  Interfaces.Fortran;
with lapack; use lapack;


Procedure tzhpsv is

	use lapack.Integer_IO;
	use lapack.Double_Precision_IO;

	N	 : Fortran_Integer := 3;
	AP	 : Fortran_Complex_Star_16_Vector ( 1..6 );
	IPIV	 : Fortran_Integer_Vector ( 1..N );
	B,Y	 : Fortran_Complex_Star_16_Matrix ( 1..N, 1..N);
	INFO	 : Fortran_Integer;

	A,Z      : Fortran_Complex_Star_16_Matrix ( 1..N, 1..N);

	ERR : Double_Precision := 0.0;

begin

        -- A is Hermitian matrix
        A := (( ( 3.0, 0.0), ( 1.0,-2.0), ( 4.0, 7.0)),
              ( ( 1.0,+2.0), (-4.0, 0.0), ( 0.0,-2.0)),
              ( ( 4.0,-7.0), ( 0.0, 2.0), ( 2.0, 0.0)));

        -- AP is packed  arrays
        AP := ( A(1,1), A(1,2), A(2,2), A(1,3), A(2,3), A(3,3));


        B := (( (9.0, 3.0), ( 9.0, 7.0), ( 16.0, 11.0)),
              ( (2.0, 7.0), (-2.0,-1.0), ( -4.0,  4.0)),
              ( (5.0,-2.0), ( 8.0, 2.0), (-11.0, -3.0)));

        Y := B;

	ZHPSV (
	UPLO	 => 'U',
	N	 => N,
	NRHS	 => N,
	AP	 => AP,
	IPIV	 => IPIV,
	B	 => B,
	LDB	 => N,
	INFO	 => INFO);

	-- Test if error
	if (INFO /= 0) then
	   Put ("ERROR ");
	   Put ( INFO );
	   New_line;
	end if;

	-- Verify routine
        for I in Z'Range (1) loop
           for J in Z'Range(2) loop
              Z(I,J) := (0.0,0.0);
              for K in A'Range(2) loop
                 Z(I,J) := Z(I,J) + ( A(I,K) * B(K,J));
              end loop;
              ERR := ERR + abs (Z(I,J) - Y(I,J));
           end loop;
        end loop;

	PUT ( "Abs Error:");
	PUT ( ERR );
	New_line;

end tzhpsv;
