with Ada.Text_IO;
use  Ada.Text_IO;
with Interfaces.Fortran;
use  Interfaces.Fortran;
with lapack; 

Procedure tzhesv is

	use lapack.Integer_IO;
	use lapack.Double_Precision_IO;
	use type lapack.Complex_Star_16;

	N	 : Fortran_Integer := 3;
	A,X	 : lapack.Fortran_Complex_Star_16_Matrix ( 1..N, 1..N);
	IPIV	 : lapack.Fortran_Integer_Vector ( 1..N );
	B,Y	 : lapack.Fortran_Complex_Star_16_Matrix ( 1..N, 1..N);
	LWORK	 : Fortran_Integer := N;
	WORK	 : lapack.Fortran_Complex_Star_16_Vector ( 1..LWORK );
	INFO	 : Fortran_Integer;

        Z        : lapack.Fortran_Complex_Star_16_Matrix ( 1..N, 1..N);
	ERR : Double_Precision := 0.0;

begin

	-- A is Hermitian matrix
        A := (( ( 3.0, 0.0), ( 1.0,-2.0), ( 4.0, 7.0)),
              ( ( 1.0,+2.0), (-4.0, 0.0), ( 0.0,-2.0)),
              ( ( 4.0,-7.0), ( 0.0, 2.0), ( 2.0, 0.0)));

        B := (( (9.0, 3.0), ( 9.0, 7.0), ( 16.0, 11.0)),
              ( (2.0, 7.0), (-2.0,-1.0), ( -4.0,  4.0)),
              ( (5.0,-2.0), ( 8.0, 2.0), (-11.0, -3.0)));

	X := A;
	Y := B;

	lapack.ZHESV (
	UPLO	 => 'U',
	N	 => N,
	NRHS	 => N,
	A	 => A,
	LDA	 => N,
	IPIV	 => IPIV,
	B	 => B,
	LDB	 => N,
	WORK	 => WORK,
	LWORK	 => LWORK,
	INFO	 => INFO);

	-- Test if error
	if (INFO /= 0) then
	   Put ("ERROR ");
	   Put ( INFO );
	   New_line;
	end if;

	-- Verify routine
        for I in Z'Range (1) loop
           for J in Z'Range(2) loop
              Z(I,J) := (0.0,0.0);
              for K in A'Range(2) loop
                 Z(I,J) := Z(I,J) + ( X(I,K) * B(K,J));
              end loop;
              ERR := ERR + abs (Z(I,J) - Y(I,J));
           end loop;
        end loop;

	PUT ( "Abs Error:");
	PUT ( ERR );
	New_line;

end tzhesv;
