with Ada.Text_IO; 
use  Ada.Text_IO;
with Interfaces.Fortran; 
use  Interfaces.Fortran;
with lapack; 

procedure tzgbsv is 

    	use lapack.Double_Precision_IO;
    	use type lapack.Complex_Star_16;

	N: Fortran_Integer := 3;
	A: lapack.Fortran_Complex_Star_16_Matrix ( 1..N, 1..N );
	AB: lapack.Fortran_Complex_Star_16_Matrix ( 1..4, 1..N );
	B,Y: lapack.Fortran_Complex_Star_16_Matrix ( 1..N, 1..N );
	Z: lapack.Fortran_Complex_Star_16_Matrix ( 1..N, 1..N );
	
	ERR: Double_Precision := 0.0;
	IPIV : lapack.Fortran_Integer_Vector ( 1..N ); 
	INFO : Fortran_Integer;
begin 
	A := (( (2.0, 1.0), ( 1.0, 3.0), ( 0.0,0.0) ),
              ( (2.0,-1.0), ( 2.0, 4.0), (-1.0,2.0) ),
              ( (0.0, 0.0), (-1.0,-1.0), ( 6.0,1.0) ));

	-- AB is A in band storage scheme
	-- ku = kl = 1; LDAB = 2 *1+1+1 = 4

	AB := (( (0.0, 0.0), ( 0.0, 0.0), ( 0.0, 0.0)),
	       ( (0.0, 0.0), ( 1.0, 3.0), (-1.0, 2.0)),
               ( (2.0, 1.0), ( 2.0, 4.0), ( 6.0, 1.0)),
               ( (2.0,-1.0), (-1.0,-1.0), ( 0.0, 0.0)) );
	
        B := (( (9.0,3.0),  (9.0,7.0), (16.0,11.0)),
              ( (2.0,2.0), (-1.0,-2.0),(-1.0,4.0)),
              ( (5.0,-2.0), (8.0,2.0),(-11.0,-3.0)));

	Y := B;

	lapack.ZGBSV (
	       N    => N,
	       KL   => 1,
	       KU   => 1,
	       NRHS => N,
	       AB   => AB,
	       LDAB => 4,
	       IPIV => IPIV,
	       B    => B,
	       LDB  => N,
	       INFO => INFO );

	if (INFO /= 0) then 
	   PUT ("ERROR");
	end if;


        for I in Z'Range (1) loop
	   for J in Z'Range(2) loop
	      Z(I,J) := (0.0,0.0);
	      for K in A'Range(2) loop
		 Z(I,J) := Z(I,J) + ( A(I,K) * B(K,J));
	      end loop;
	      ERR := ERR + abs (Z(I,J) - Y(I,J));
	   end loop;
	end loop;

	-- PUT (Y);
	-- PUT (Z);
	PUT ( "Abs Error:");
	PUT ( ERR );
	New_line;

end tzgbsv;


