with Ada.Text_IO; 
use  Ada.Text_IO;
with Interfaces.Fortran; 
use  Interfaces.Fortran;
with lapack; 

procedure tssysv is 

    use lapack.Real_IO;

	N: Fortran_Integer := 3;
	A,X: lapack.Fortran_Real_Matrix ( 1..N, 1..N );
	B,Y: lapack.Fortran_Real_Matrix ( 1..N, 1..N );
	Z: lapack.Fortran_Real_Matrix ( 1..N, 1..N );
	WORK: lapack.Fortran_Real_Vector ( 1..9 );
	ERR: Real := 0.0;
	IPIV : lapack.Fortran_Integer_Vector ( 1..N ); 
	INFO : Fortran_Integer;
begin 
	-- A is symmetric matrix
	A := (( 2.0,  1.0, -2.0),
              ( 1.0,  2.0, -1.0),
              (-2.0, -1.0,  6.0));

	B := (( 9.0,  9.0, 16.0),
	      ( 2.0, -2.0,  4.0),
	      ( 5.0,  8.0,-11.0));


	X := A;
	Y := B;

	lapack.SSYSV (
        UPLO     => 'U',
        N        => N,
        NRHS     => N,
        A        => A,
        LDA      => N,
        IPIV     => IPIV,
        B        => B,
        LDB      => N,
        WORK     => WORK,
        LWORK    => 9,
        INFO     => INFO );

        if (INFO /= 0) then 
           Put_line ("ERROR");
        end if;

        for I in Z'Range (1) loop
	   for J in Z'Range(2) loop
	      Z(I,J) := 0.0;
	      for K in X'Range(2) loop
		 Z(I,J) := Z(I,J) + ( X(I,K) * B(K,J));
	      end loop;
	      ERR := ERR + abs (Z(I,J) - Y(I,J));
	   end loop;
	end loop;

	PUT ( "Abs Error:");
	PUT ( ERR );
	New_line;

end tssysv;


