with Ada.Text_IO;  use  Ada.Text_IO;
with Interfaces.Fortran;  use  Interfaces.Fortran;
with lapack; 

procedure tsgtsv is 

    use lapack.Real_IO;

	N: Fortran_Integer := 3;
	A: lapack.Fortran_Real_Matrix ( 1..N, 1..N );

	DL, DU: lapack.Fortran_Real_Vector ( 1..N-1 );
	D : lapack.Fortran_Real_Vector ( 1..N );

	B,Y: lapack.Fortran_Real_Matrix ( 1..N, 1..N );
	Z: lapack.Fortran_Real_Matrix ( 1..N, 1..N );
	
	ERR: Real := 0.0;
	INFO : Fortran_Integer;
begin 
   
        -- A is tridiagonal metric

	A := (( 2.0, -1.0,  0.0),
              ( 3.0,  2.0, -1.0),
              ( 0.0, -5.0,  6.0));

	-- DU, D, DL is tridiagonal arrat

	DU := (-1.0, -1.0);
	D  := ( 2.0,  2.0, 6.0);
	DL := ( 3.0, -5.0);
	

	B := (( 9.0,  9.0, 16.0),
	      ( 7.0, -2.0,  4.0),
	      ( 2.0,  8.0,-11.0));

	Y := B;

	lapack.SGTSV (
	N	 => N,
	NRHS	 => N,
	DL	 => DL,
	D	 => D,
	DU	 => DU,
	B	 => B,
	LDB	 => N,
	INFO	 => INFO);


	if (INFO /= 0) then 
	   Put_line ("ERROR");
	end if;


        for I in Z'Range (1) loop
	   for J in Z'Range(2) loop
	      Z(I,J) := 0.0;
	      for K in A'Range(2) loop
		 Z(I,J) := Z(I,J) + ( A(I,K) * B(K,J));
	      end loop;
	      ERR := ERR + abs (Z(I,J) - Y(I,J));
	   end loop;
	end loop;

        -- PUT (Y);
        -- PUT (Z);
	PUT ( "Abs Error:");
	PUT ( ERR );
	New_line;

end tsgtsv;



