with Ada.Text_IO;  use  Ada.Text_IO;
with Interfaces.Fortran; use  Interfaces.Fortran;
with lapack; 


procedure tgesv is 

        use lapack.Real_IO;
        use lapack.Double_Precision_IO;
        use type lapack.Complex_Star_16;

	N: Fortran_Integer := 3;

	AC,XC: lapack.Fortran_Complex_Matrix ( 1..N, 1..N );
	BC,YC: lapack.Fortran_Complex_Matrix ( 1..N, 1..N );
	ZC: lapack.Fortran_Complex_Matrix ( 1..N, 1..N );
	
	AD,XD: lapack.Fortran_Double_Precision_Matrix ( 1..N, 1..N );
	BD,YD: lapack.Fortran_Double_Precision_Matrix ( 1..N, 1..N );
	ZD: lapack.Fortran_Double_Precision_Matrix ( 1..N, 1..N );	

	AS,XS: lapack.Fortran_Real_Matrix ( 1..N, 1..N );
	BS,YS: lapack.Fortran_Real_Matrix ( 1..N, 1..N );
	ZS: lapack.Fortran_Real_Matrix ( 1..N, 1..N );

	AZ,XZ: lapack.Fortran_Complex_Star_16_Matrix ( 1..N, 1..N );
	BZ,YZ: lapack.Fortran_Complex_Star_16_Matrix ( 1..N, 1..N );
	ZZ: lapack.Fortran_Complex_Star_16_Matrix ( 1..N, 1..N );
	

	IPIV : lapack.Fortran_Integer_Vector ( 1..N ); 
	INFO : Fortran_Integer;
	
	ERRS: Real := 0.0;
	ERRD: Double_Precision := 0.0;

begin 
	AC := (( (2.0,1.0),  (1.0,5.0),  (1.0,-1.0) ),
              ( (2.0,-2.0), (2.0,-4.0), (-1.0,-1.0)),
              ( (4.0,2.0),  (7.0,-1.0),  (6.0,3.0) ));

	BC := (( (9.0,3.0),  (9.0,7.0), (16.0,11.0)),
	      ( (2.0,2.0), (-1.0,-2.0),(-1.0,4.0)),
	      ( (5.0,-2.0), (8.0,2.0),(-11.0,-3.0)));


	XC := AC;
	YC := BC;

	lapack.CGESV (	N    => N,
          	NRHS => N,
          	A    => AC,
          	LDA  => N,
          	IPIV => IPIV,
          	B    => BC,
          	LDB  => N,
          	INFO => INFO);

        if (INFO /= 0) then 
           Put_line ("ERROR");
        end if;


        for I in ZC'Range (1) loop
	   for J in ZC'Range(2) loop
	      ZC(I,J) := (0.0,0.0);
	      for K in XC'Range(2) loop
		 ZC(I,J) := ZC(I,J) + ( XC(I,K) * BC(K,J));
	      end loop;
	      ERRS := ERRS + abs (ZC(I,J) - YC(I,J));
	   end loop;
	end loop;

	PUT ( "Abs Error:");
	PUT ( ERRS );
	New_line;
	ERRS := 0.0;


	AD := ((2.0,  1.0,  1.0),
              (2.0,  2.0, -1.0),
              (4.0, -1.0,  6.0));

	BD := (( 9.0,  9.0, 16.0),
	      ( 2.0, -2.0,  4.0),
	      ( 5.0,  8.0,-11.0));


	XD := AD;
	YD := BD;

	lapack.DGESV (	N    => N,
          	NRHS => N,
          	A    => AD,
          	LDA  => N,
          	IPIV => IPIV,
          	B    => BD,
          	LDB  => N,
          	INFO => INFO);

        if (INFO /= 0) then 
           Put_line ("ERROR");
        end if;

        for I in ZD'Range (1) loop
	   for J in ZD'Range(2) loop
	      ZD(I,J) := 0.0;
	      for K in XD'Range(2) loop
		 ZD(I,J) := ZD(I,J) + ( XD(I,K) * BD(K,J));
	      end loop;
	      ERRD := ERRD + abs (ZD(I,J) - YD(I,J));
	   end loop;
	end loop;

	PUT ( "Abs Error:");
	PUT ( ERRD );
	New_line;
	ERRD := 0.0;

	AS := ((2.0,  1.0,  1.0),
              (2.0,  2.0, -1.0),
              (4.0, -1.0,  6.0));

	BS := (( 9.0,  9.0, 16.0),
	      ( 2.0, -2.0,  4.0),
	      ( 5.0,  8.0,-11.0));


	XS := AS;
	YS := BS;

	lapack.SGESV (	N    => N,
          	NRHS => N,
          	A    => AS,
          	LDA  => N,
          	IPIV => IPIV,
          	B    => BS,
          	LDB  => N,
          	INFO => INFO);

        if (INFO /= 0) then 
           Put_line ("ERROR");
        end if;

        for I in ZS'Range (1) loop
	   for J in ZS'Range(2) loop
	      ZS(I,J) := 0.0;
	      for K in XS'Range(2) loop
		 ZS(I,J) := ZS(I,J) + ( XS(I,K) * BS(K,J));
	      end loop;
	      ERRS := ERRS + abs (ZS(I,J) - YS(I,J));
	   end loop;
	end loop;

	PUT ( "Abs Error:");
	PUT ( ERRS );
	New_line;
	ERRS := 0.0;

	AZ := (( (2.0,1.0),  (1.0,5.0),  (1.0,-1.0) ),
              ( (2.0,-2.0), (2.0,-4.0), (-1.0,-1.0)),
              ( (4.0,2.0),  (7.0,-1.0),  (6.0,3.0) ));

	BZ := (( (9.0,3.0),  (9.0,7.0), (16.0,11.0)),
	      ( (2.0,2.0), (-1.0,-2.0),(-1.0,4.0)),
	      ( (5.0,-2.0), (8.0,2.0),(-11.0,-3.0)));


	XZ := AZ;
	YZ := BZ;

	lapack.ZGESV (	N    => N,
          	NRHS => N,
          	A    => AZ,
          	LDA  => N,
          	IPIV => IPIV,
          	B    => BZ,
          	LDB  => N,
          	INFO => INFO);

        if (INFO /= 0) then 
           Put_line ("ERROR");
        end if;

        for I in ZZ'Range (1) loop
	   for J in ZZ'Range(2) loop
	      ZZ(I,J) := (0.0,0.0);
	      for K in XZ'Range(2) loop
		 ZZ(I,J) := ZZ(I,J) + ( XZ(I,K) * BZ(K,J));
	      end loop;
	      ERRD := ERRD + abs (ZZ(I,J) - YZ(I,J));
	   end loop;
	end loop;

	PUT ( "Abs Error:");
	PUT ( ERRD );
	New_line;
	ERRD := 0.0;

end tgesv;


