with Ada.Text_IO;  use  Ada.Text_IO;
with Interfaces.Fortran;  use  Interfaces.Fortran;
with lapack; 

procedure tdptsv is 

    use lapack.Double_Precision_IO;

	N: Fortran_Integer := 3;
	A: lapack.Fortran_Double_Precision_Matrix ( 1..N, 1..N );

	E : lapack.Fortran_Double_Precision_Vector ( 1..N-1 );
	D : lapack.Fortran_Double_Precision_Vector ( 1..N );

	B,Y: lapack.Fortran_Double_Precision_Matrix ( 1..N, 1..N );
	Z: lapack.Fortran_Double_Precision_Matrix ( 1..N, 1..N );
	
	ERR: Double_Precision := 0.0;
	INFO : Fortran_Integer;
begin 
   
        -- A is symmetric positive definite tridiagonal metric

	A := (( 2.0, -1.0,  0.0),
              (-1.0,  2.0, -1.0),
              ( 0.0, -1.0,  6.0));

	-- D, E are tridiagonal arrays
        E :=  (A(1,2),A(2,3));
        D :=  (A(1,1),A(2,2),A(3,3));
	
	B := (( 9.0,  9.0, 16.0),
	      ( 7.0, -2.0,  4.0),
	      ( 2.0,  8.0,-11.0));

	Y := B;

	lapack.DPTSV (
	N	 => N,
	NRHS	 => N,
	D	 => D,
	E	 => E,
	B	 => B,
	LDB	 => N,
	INFO	 => INFO );

	if (INFO /= 0) then 
	   Put_line ("ERROR");
	end if;


        for I in Z'Range (1) loop
	   for J in Z'Range(2) loop
	      Z(I,J) := 0.0;
	      for K in A'Range(2) loop
		 Z(I,J) := Z(I,J) + ( A(I,K) * B(K,J));
	      end loop;
	      ERR := ERR + abs (Z(I,J) - Y(I,J));
	   end loop;
	end loop;

        -- PUT (Y);
        -- PUT (Z);
	PUT ( "Abs Error:");
	PUT ( ERR );
	New_line;

end tdptsv;



