with Ada.Text_IO;  use  Ada.Text_IO;
with Interfaces.Fortran;  use  Interfaces.Fortran;
with lapack; 

procedure tcposv is 

	use lapack.Real_IO;
        use lapack.Integer_IO;

	N: Fortran_Integer := 3;

	A,X: lapack.Fortran_Complex_Matrix ( 1..N, 1..N );
	B,Y: lapack.Fortran_Complex_Matrix ( 1..N, 1..N );
	Z,AA: lapack.Fortran_Complex_Matrix ( 1..N, 1..N );

	ERR: Real := 0.0;
	
	INFO : Fortran_Integer;
begin 

	-- let AA is arbitrary matric
	AA := (( (2.0, 1.0), (1.0, 5.0), ( 1.0,-1.0)),
              ( (2.0,-2.0), (2.0,-4.0), (-1.0,-1.0)),
              ( (4.0, 2.0), (7.0,-1.0), ( 6.0, 3.0)));

	-- A := A * (A*) is Hermitance Positive def.
        for I in AA'Range (1) loop
	   for J in AA'Range(2) loop
	      A(I,J) := (0.0,0.0);
	      for K in AA'Range(2) loop
		 A(I,J) := A(I,J) + ( AA(I,K) * Conjugate(AA(J,K)));
	      end loop;
	   end loop;
	end loop;
	
	-- PUT(A);

        B := (( (9.0, 3.0), ( 1.0,-2.0), ( 16.0, 11.0)),
              ( (2.0, 7.0), (-2.0,-1.0), ( -4.0,  4.0)),
              ( (1.0,-2.0), ( 8.0, 2.0), (-11.0,  3.0)));

	X := A;
	Y := B;

	lapack.CPOSV (
        UPLO     => 'U',
        N        => N,
        NRHS     => N,
        A        => A,
        LDA      => N,
        B        => B,
        LDB      => N,
        INFO     => INFO );

        if (INFO /= 0) then 
           Put ("ERROR");
           Put ( INFO );
	   New_line;
        end if;

        for I in Z'Range (1) loop
	   for J in Z'Range(2) loop
	      Z(I,J) := (0.0,0.0);
	      for K in X'Range(2) loop
		 Z(I,J) := Z(I,J) + ( X(I,K) * B(K,J));
	      end loop;
	      ERR := ERR + abs (Z(I,J) - Y(I,J));
	   end loop;
	end loop;

	PUT ( "Abs Error:");
	PUT ( ERR );
	New_line;

end tcposv;
