with Ada.Text_IO; use  Ada.Text_IO;
with Interfaces.Fortran; use  Interfaces.Fortran;
with lapack;

Procedure tzhpev is

	use lapack.Integer_IO;
	use lapack.Double_Precision_IO;
	use type lapack.Complex_Star_16;

	N	 : Fortran_Integer := 3;
	AP	 : lapack.Fortran_Complex_Star_16_Vector ( 1..(N*(N+1)/2) );
	W	 : lapack.Fortran_Double_Precision_Vector ( 1..N );
	Z,A	 : lapack.Fortran_Complex_Star_16_Matrix ( 1..N, 1..N);
	WORK	 : lapack.Fortran_Complex_Star_16_Vector ( 1..2*N-1 );
	RWORK	 : lapack.Fortran_Double_Precision_Vector ( 1..3*N-2 );
	INFO	 : Fortran_Integer;

	TMP : lapack.Complex_Star_16 := (0.0,0.0);
	ERR : Double_Precision := 0.0;

begin
        -- A is Hermitian matrix
        A := (( ( 3.0, 0.0), ( 1.0,-2.0), ( 4.0, 7.0)),
              ( ( 1.0,+2.0), (-4.0, 0.0), ( 0.0,-2.0)),
              ( ( 4.0,-7.0), ( 0.0, 2.0), ( 2.0, 0.0)));

        -- AP is packed  arrays
        AP := ( A(1,1), A(1,2), A(2,2), A(1,3), A(2,3), A(3,3));


	lapack.ZHPEV (
	JOBZ	 => 'V',
	UPLO	 => 'U',
	N	 => N,
	AP	 => AP,
	W	 => W,
	Z	 => Z,
	LDZ	 => N,
	WORK	 => WORK,
	RWORK	 => RWORK,
	INFO	 => INFO);

	-- Test if error
	if (INFO /= 0) then
	   Put ("ERROR ");
	   Put ( INFO );
	   New_line;
	end if;

	-- Verify routine

        ERR := 0.0;

        for I in W'Range(1) loop

          for J in A'Range(1) loop
            TMP := (0.0,0.0);

            for K in A'Range(2) loop
                TMP := TMP + ( A(J,K) * Z(K,I) ) ;
            end loop;

            TMP := TMP - ( W(I) * Z(J,I) );
            -- PUT (TMP);
            -- new_line;
            ERR := ERR + abs( TMP );
          end loop;
          
        end loop;
                

	PUT ( "Abs Error:");
	PUT ( ERR );
	New_line;

end tzhpev;
