with Ada.Text_IO; use  Ada.Text_IO;
with Interfaces.Fortran; use  Interfaces.Fortran;
with lapack;

Procedure tzgeev is

	use lapack.Integer_IO;
	use lapack.Double_Precision_IO;
	use type lapack.Complex_Star_16;

	N	 : Fortran_Integer := 3;
	A	 : lapack.Fortran_Complex_Star_16_Matrix ( 1..N, 1..N);
	W	 : lapack.Fortran_Complex_Star_16_Vector ( 1..N );
	VL	 : lapack.Fortran_Complex_Star_16_Matrix ( 1..N, 1..N);
	VR	 : lapack.Fortran_Complex_Star_16_Matrix ( 1..N, 1..N);
        LWORK    : Fortran_Integer := 4*N;
        WORK     : lapack.Fortran_Complex_Star_16_Vector ( 1..LWORK );
	RWORK	 : lapack.Fortran_Double_Precision_Vector ( 1..2*N );
	INFO	 : Fortran_Integer;

        X      : lapack.Fortran_Complex_Star_16_Matrix ( 1..N, 1..N);

	TMP	: lapack.Complex_Star_16 := (0.0,0.0);
	ERR  	: Double_Precision := 0.0;

begin
        A := (( (2.0, 1.0), (1.0, 5.0), ( 1.0,-1.0)),
              ( (2.0,-2.0), (2.0,-4.0), (-1.0,-1.0)),
              ( (4.0, 2.0), (7.0,-1.0), ( 6.0, 3.0)));

	X := A;

	lapack.ZGEEV (
	JOBVL	 => 'V',
	JOBVR	 => 'V',
	N	 => N,
	A	 => A,
	LDA	 => N,
	W	 => W,
	VL	 => VL,
	LDVL	 => N,
	VR	 => VR,
	LDVR	 => N,
	WORK	 => WORK,
	LWORK	 => LWORK,
	RWORK	 => RWORK,
	INFO	 => INFO);

	-- Test if error
	if (INFO /= 0) then
	   Put ("ERROR ");
	   Put ( INFO );
	   New_line;
	end if;

	-- Verify routine
        ERR := 0.0;

        for I in W'Range(1) loop

          for J in X'Range(1) loop
            TMP := (0.0,0.0);

            for K in X'Range(2) loop
                TMP := TMP + ( X(J,K) * VR(K,I) ) ;
            end loop;

            TMP := TMP - ( W(I) * VR(J,I) );
            -- PUT (TMP);
            -- new_line;
            ERR := ERR + abs( TMP );
          end loop;
          
        end loop;
                

	PUT ( "Abs Error:");
	PUT ( ERR );
	New_line;

end tzgeev;
