with Ada.Text_IO; use  Ada.Text_IO;
with Interfaces.Fortran; use  Interfaces.Fortran;
with lapack;


Procedure tsstevd is

	use lapack.Integer_IO;
	use lapack.Real_IO;

	N	 : Fortran_Integer := 3;
	D	 : lapack.Fortran_Real_Vector ( 1..N );
	E	 : lapack.Fortran_Real_Vector ( 1..N-1 );
	Z,A	 : lapack.Fortran_Real_Matrix ( 1..N, 1..N);

        LWORK    : Fortran_Integer := 60;
        WORK     : lapack.Fortran_Real_Vector ( 1..LWORK );
        LIWORK   : Fortran_Integer := 2 + 5 * N;
        IWORK    : lapack.Fortran_Integer_Vector ( 1..LIWORK );
	
	INFO	 : Fortran_Integer;

	ERR, TMP : Real := 0.0;

begin

        -- A is symmetric positive definite tridiagonal metric

        A := (( 2.0, -1.0,  0.0),
              (-1.0,  2.0, -1.0),
              ( 0.0, -1.0,  6.0));

        -- D, E are tridiagonal arrays

        E :=  (A(1,2),A(2,3));
        D :=  (A(1,1),A(2,2),A(3,3));
        

	lapack.SSTEVD (
	JOBZ	 => 'V',
	N	 => N,
	D	 => D,
	E	 => E,
	Z	 => Z,
	LDZ	 => N,
	WORK	 => WORK,
	LWORK	 => LWORK,
	IWORK	 => IWORK,
	LIWORK	 => LIWORK,
	INFO	 => INFO);

	-- Test if error
	if (INFO /= 0) then
	   Put ("ERROR ");
	   Put ( INFO );
	   New_line;
	end if;

	-- Verify routine
        ERR := 0.0;

        for I in D'Range(1) loop

          for J in A'Range(1) loop
            TMP := 0.0;

            for K in A'Range(2) loop
                TMP := TMP + ( A(J,K) * Z(K,I) ) ;
            end loop;

            TMP := TMP - ( D(I) * Z(J,I) );
            -- PUT (TMP);
            -- new_line;
            ERR := ERR + abs( TMP );
          end loop;
          
        end loop;


	PUT ( "Abs Error:");
	PUT ( ERR );
	New_line;

end tsstevd;
