with Ada.Text_IO; use  Ada.Text_IO;
with Interfaces.Fortran; use  Interfaces.Fortran;
with lapack;

Procedure tsspevd is

	use lapack.Integer_IO;
	use lapack.Real_IO;

	N	 : Fortran_Integer := 3;
	AP	 : lapack.Fortran_Real_Vector ( 1..6 );
	W	 : lapack.Fortran_Real_Vector ( 1..N );
	Z,A	 : lapack.Fortran_Real_Matrix ( 1..N, 1..N);

	LWORK	 : Fortran_Integer := 60;
	WORK	 : lapack.Fortran_Real_Vector ( 1..LWORK );
        LIWORK   : Fortran_Integer := 2 + 5 * N;
	IWORK	 : lapack.Fortran_Integer_Vector ( 1..LIWORK );
	INFO	 : Fortran_Integer;

	ERR, TMP : Real := 0.0;

begin
        -- A is symmetric  metric
        A := (( 2.0, -1.0,  4.0),
              (-1.0,  2.0, -2.0),
              ( 4.0, -2.0,  6.0));

        -- AP is packed  arrays
        AP := ( A(1,1), A(1,2), A(2,2), A(1,3), A(2,3), A(3,3));


	lapack.SSPEVD (
	JOBZ	 => 'V',
	UPLO	 => 'U',
	N	 => N,
	AP	 => AP,
	W	 => W,
	Z	 => Z,
	LDZ	 => N,
	WORK	 => WORK,
	LWORK	 => LWORK,
	IWORK	 => IWORK,
	LIWORK	 => LIWORK,
	INFO	 => INFO);

	-- Test if error
	if (INFO /= 0) then
	   Put ("ERROR ");
	   Put ( INFO );
	   New_line;
	end if;

	-- Verify routine
        ERR := 0.0;

        for I in W'Range(1) loop

          for J in A'Range(1) loop
            TMP := 0.0;

            for K in A'Range(2) loop
                TMP := TMP + ( A(J,K) * Z(K,I) ) ;
            end loop;

            TMP := TMP - ( W(I) * Z(J,I) );
            -- PUT (TMP);
            -- new_line;
            ERR := ERR + abs( TMP );
          end loop;
          
        end loop;


	PUT ( "Abs Error:");
	PUT ( ERR );
	New_line;

end tsspevd;
