with Ada.Text_IO; use  Ada.Text_IO;
with Interfaces.Fortran; use  Interfaces.Fortran;
with lapack;

Procedure tsgeev is

	use lapack.Integer_IO;
	use lapack.Real_IO;

	N	 : Fortran_Integer := 3;
	A	 : lapack.Fortran_Real_Matrix ( 1..N, 1..N);
	WR	 : lapack.Fortran_Real_Vector ( 1..N );
	WI	 : lapack.Fortran_Real_Vector ( 1..N );
	VL	 : lapack.Fortran_Real_Matrix ( 1..N, 1..N);
	VR	 : lapack.Fortran_Real_Matrix ( 1..N, 1..N);
	LWORK	 : Fortran_Integer := 4*N;
	WORK	 : lapack.Fortran_Real_Vector ( 1..LWORK );
	INFO	 : Fortran_Integer;

	X	 : lapack.Fortran_Real_Matrix ( 1..N, 1..N);

	ERR, TMP : Real := 0.0;

begin
        A := ((2.0,  1.0,  1.0),
              (2.0,  2.0, -1.0),
              (4.0, -1.0,  6.0));

	X := A;

	lapack.SGEEV (
	JOBVL	 => 'V',
	JOBVR	 => 'V',
	N	 => N,
	A	 => A,
	LDA	 => N,
	WR	 => WR,
	WI	 => WI,
	VL	 => VL,
	LDVL	 => N,
	VR	 => VR,
	LDVR	 => N,
	WORK	 => WORK,
	LWORK	 => LWORK,
	INFO	 => INFO);

	-- Test if error
	if (INFO /= 0) then
	   Put ("ERROR ");
	   Put ( INFO );
	   New_line;
	end if;

	-- Verify routine
	-- X is a copy of A
	-- WR is Eigen values Real part
	-- WI is Eigen values Im part
	-- VL and VR are Eigen vector
	-- A * VL(n,1) = WR(n)* VL(n,1)

	--PUT ( WR ); 
	--PUT ( WI );
	--PUT ( VL );

	ERR := 0.0;

	for I in WR'Range(1) loop

	  for J in X'Range(1) loop
 	    TMP := 0.0;

	    for K in X'Range(2) loop
		TMP := TMP + ( X(J,K) * VR(K,I) ) ;
	    end loop;

	    TMP := TMP - ( WR(I) * VR(J,I) );
	    -- PUT (TMP);
	    -- new_line;
	    ERR := ERR + abs( TMP );
	  end loop;
	  
	end loop;
		

	PUT ( "Abs Error:");
	PUT ( ERR );
	New_line;

end tsgeev;
