with Ada.Text_IO; use  Ada.Text_IO;
with Interfaces.Fortran; use  Interfaces.Fortran;
with lapack;

Procedure tdsyev is

	use lapack.Integer_IO;
	use lapack.Double_Precision_IO;

	N	 : Fortran_Integer := 3;
	A, X	 : lapack.Fortran_Double_Precision_Matrix ( 1..N, 1..N);
	W	 : lapack.Fortran_Double_Precision_Vector ( 1..N );
	LWORK	 : Fortran_Integer := 3 * N - 1 ;
	WORK	 : lapack.Fortran_Double_Precision_Vector ( 1..LWORK );
	INFO	 : Fortran_Integer;

	ERR, TMP : Double_Precision := 0.0;

begin

        -- A is symmetric matrix
        A := (( 2.0,  1.0, -2.0),
              ( 1.0,  2.0, -1.0),
              (-2.0, -1.0,  6.0));

	X := A;

	lapack.DSYEV (
	JOBZ	 => 'V',
	UPLO	 => 'U',
	N	 => N,
	A	 => A,
	LDA	 => N,
	W	 => W,
	WORK	 => WORK,
	LWORK	 => LWORK,
	INFO	 => INFO);

	-- Test if error
	if (INFO /= 0) then
	   Put ("ERROR ");
	   Put ( INFO );
	   New_line;
	end if;

	-- Verify routine
        ERR := 0.0;

        for I in W'Range(1) loop

          for J in X'Range(1) loop
            TMP := 0.0;

            for K in X'Range(2) loop
                TMP := TMP + ( X(J,K) * A(K,I) ) ;
            end loop;

            TMP := TMP - ( W(I) * A(J,I) );
            -- PUT (TMP);
            -- new_line;
            ERR := ERR + abs( TMP );
          end loop;
          
        end loop;
                

	PUT ( "Abs Error:");
	PUT ( ERR );
	New_line;

end tdsyev;
